#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p28, p27);  // tx, rx

int main() {
    int i;
    device.baud(19200);
    char auto_command[]
       = {0xaa, 0xbb, 0x12, 0x04, 0x02, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x11};
    char success_command[]
        ={0xaa, 0xbb, 0x02, 0x04, 0x06};
    
    
    for(i=0;i<21;i++)
        device.putc(auto_command[i]);
    
    for(i=0;i<5;i++){
        if(success_command[i] != device.getc()){
            pc.printf("Program failure...\n");
            return -1;
        }
    }
    pc.printf("Program success!\n");
    led1=1;
    led2=1;
    led3=1;
    led4=1;
    return 0;
}
