#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "ItemSet.h"
#include "member.h"
#include "MyRFID.h"


EthernetNetIf eth;
NTPClient ntp;

LocalFileSystem local("local");

Serial pc(USBTX, USBRX); // tx, rx

MyRFID rfid(p28, p27);//tx,rx
InterruptIn rfid_irq(p21);

TextLCD lcd(p5, p6, p11, p12, p13, p14); // rs, e, d0-d3

BusOut myleds(LED1, LED2, LED3, LED4);

const char user[] = "username";
const char pass[] = "password";
const char login_msg[] = " is login now.";
const char logout_msg[] = " is logout now.";
const char url[]  = "http://api.supertweet.net/1/statuses/update.xml";
const char ntp_server[]  = "0.uk.pool.ntp.org";

bool card_flag=false;

void cardIRQ() {
    card_flag=true;
}

void LED_KnightRider(int rideTime) {
        for (int i=0; i<4; i++) {
            myleds = 1 << i;
            wait_ms(rideTime);
        }
        for (int i=0;i<3;i++) {
            myleds =4>>i;
            wait_ms(rideTime);
        }
    myleds=0;
}

int main() {
    ItemSet memberList;
    Object* theObj;

    rfid.baud(19200);
    printf("Init\n");
    lcd.printf("Init\n");

    char sendmsg[255];
    char buf[40];
    time_t ctTime;
    HTTPClient twitter;
    HTTPMap msg;
    
    unsigned int id;
    
    //ethernet setup
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
      printf("Error %d in setup.\n", ethErr);
      return -1;
    }
    printf("Setup OK\r\n");

    //twitter auth
    twitter.basicAuth(user, pass); //We use basic authentication, replace with you account's parameters
    
    //RTC setup
    Host server(IpAddr(), 123, ntp_server);
    ntp.setTime(server);

    //read member.txt
    pc.printf("Opening File...\n"); // Drive should be marked as removed
    FILE *fp = fopen("/local/member.txt", "r");
    char name_buf[255];
    while (fscanf( fp, "%[^,],%d\n",name_buf, &id) != EOF ) {
        memberList.AddItem(new member(name_buf,id));
    }
    delete [] name_buf;
    fclose(fp);

    rfid_irq.rise(&cardIRQ);

    while (1) {
        lcd.locate(0,0);
        ctTime = time(NULL)+32400;//JST time
        strftime(buf,sizeof(buf),"%Y/%m/%d %a\n%H:%M:%S  Ready!", localtime(&ctTime));
        printf("%s\n", buf);
        lcd.printf("%s", buf);
        wait(0.5);

        if (card_flag) {
            lcd.cls();
            strcpy(sendmsg,"");

            id = rfid.read();
            pc.printf("id=%u\n",id);
            theObj = memberList.SerchId(id);//checkId

            if (theObj != NULL) {//list has same ID
                lcd.locate(0,0);
                lcd.printf("%s\n",((member*)theObj)->GetName());
                lcd.printf("id=%u",((member*)theObj)->GetId());

                strcat(sendmsg,((member*)theObj)->GetName());
                strftime(buf,sizeof(buf), " (%Y/%m/%d %a %H:%M:%S)", localtime(&ctTime));

                if (((member*)theObj)->GetEnter()) {//member is logined
                    strcat(sendmsg,logout_msg);
                    strcat(sendmsg,buf);
                    pc.printf("%s\n",sendmsg);
                    msg["status"] = sendmsg;

                    ((member*)theObj)->SetEnter(false);
                } else {//member is logouted
                    strcat(sendmsg,login_msg);
                    strcat(sendmsg,buf);
                    pc.printf("%s\n",sendmsg);
                    msg["status"] = sendmsg;

                    ((member*)theObj)->SetEnter(true);
                }
                twitter.post(url, msg, NULL);//tweet

                LED_KnightRider(50);
                LED_KnightRider(50);

                lcd.cls();
            } else {//list no have id
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Who are you?\n");
                lcd.printf("id=%u\n",id);
                wait(5);
                
                lcd.cls();
            }
            card_flag=false;
        }
    }
}


