#include "MyRFID.h"
#include "mbed.h"

using namespace mbed;

MyRFID::MyRFID(PinName tx, PinName rx)
        : _rfid(tx,rx) {}



int MyRFID::readable(void) {
    return (_rfid.readable());
}

void MyRFID::baud(int baudrate) {
    return (_rfid.baud(baudrate));
}

unsigned int MyRFID::read(void) {

    unsigned int id=0;
    int len,i;

    _rfid.getc();//header
    _rfid.getc();//header
    len = _rfid.getc();

    char data[len];
    for (i=0;i<len;i++) {
        data[i]=_rfid.getc();
    }
    if (data[0]==0x50) {//success
        for (i=0;i<4;i++) {
            id |= (data[4-i] << (i * 8));
        }
    } else {//failre
    }

    return id;
}