#include "ItemSet.h"
#include "mbed.h"
using namespace mbed;

ItemSet::ItemSet() {
    firstItem = currentItem = NULL;
    numOfItems = 0;
}

Object* ItemSet::First() {
    currentItem = firstItem;
    if (currentItem == NULL) return(NULL);

    return(currentItem->object);
}

Object* ItemSet::Next() {
    if (currentItem != NULL) {
        if (currentItem->nextItem != NULL) {
            currentItem = currentItem->nextItem;
        }else{
            return NULL;
        }
        return(currentItem->object);
    } else {
        return(NULL);
    }
}

void ItemSet::AddItem(Object* inObj) {
    Item*  theItem;
    theItem = new Item;
    theItem->object = inObj;

    if (numOfItems == 0) {
        theItem->nextItem =NULL;
        firstItem = theItem;
    } else {
        theItem->nextItem = firstItem;
        firstItem =theItem;
    }

    currentItem = theItem;
    numOfItems++;

    return;
}

int ItemSet::GetNumOfItems() {
    return(numOfItems);
}

Object* ItemSet::GetCurrentObject() {

    if (currentItem != NULL) {
        return(currentItem->object);
    } else {
        return(NULL);
    }
}


Object* ItemSet::SerchId(unsigned int inId) {
    Item* item=firstItem;

    while (item != NULL) {
        if (item->object->CompareId(inId)) {
            return(item->object);
        }
        item = item->nextItem;
    }

    return NULL;
}
