#include "QEI.h"
#include "TextLCD.h"


TextLCD lcd(p5, p6, p11, p12, p13, p14); // rs, e, d0-d3
Serial pc(USBTX, USBRX);

#define ROTATE_PER_REVOLUTIONS  24
//Use X4 encoding.
QEI wheel(p30, p29, NC, 24, QEI::X4_ENCODING);
//Use X2 encoding by default.
//QEI wheel (p29, p30, NC, 624);

int main() {
    while(1){
        wait(0.1);
        lcd.printf("Pulses: %07d\n", wheel.getPulses());
        lcd.printf("Rotate: %04.3f\n", (double)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    }
}
