/**************************
This class referred to ADNS5020EN library
http://mbed.org/users/IPAB/programs/ADNS5020EN/5zwdp
**************************/

#ifndef _ADNS6010_H_
#define _ADNS6010_H_

#define REGISTER_PRODUCTID 0x00
#define REGISTER_REVISONID 0x01
#define REGISTER_MOTION 0x02
#define REGISTER_DELTAX 0x03
#define REGISTER_DELTAY 0x04
#define REGISTER_SQUAL  0x05
#define REGISTER_CONFIGURATION_BITS  0x0a

#define ADNS6010_PRODUCTID  0x1C
#define ADNS6010_REVISIONID 0x20

#define DELAY_TRAD    50
#define DELAY_TRAD_MOT  75
#define DELAY_RESET_PULSE 10

#include"mbed.h"

 /** Interface to control a ADNS-6010 Avago mouse 
  * chip using a SPI and 3 DigitalOuts
  */
class ADNS6010 {
public:
   /** Create the mouse chip control interface. Returns Error if the connection is not established.
    *
    * @param mosi A SPI(mosi) pin, for the spi interface of the mouse chip (SDIO)
    * @param miso A SPI(miso) pin, for the spi interface of the mouse chip (SDIO)
    * @param sclk A SPI(sclk) pin, for the spi interface of the mouse chip (SCLK)
    * @param ncs A DigitalOut, set low for chip select
    * @param reset A DigitalOut, set high for chip reset
    * @param npd A DigitalOut, set high for chip powerdown
    */
    ADNS6010(PinName mosi, PinName miso, PinName sclk, PinName ncs, PinName reset,PinName npd);
    
   /** Read the deltaX and deltaY registers and assign to the input variable the counts for the previous read.
    * 
    * @param a_dx A pointer to an integer, to return the value of the deltaX register in reading counts
    * @param a_dy A pointer to an integer, to return the value of the deltaY register in reading counts
    */
    void read_deltas(int* a_dx, int* a_dy);
    
   /** Read the SQUAL registers
    * 
    * @return  SQUAL register value an integer
    */
    int read_squal();
    
   /** Change the resolution of the mouse chip.
    * 
    * @param cpi A int value  400 or 800 or 1600 or 2000 
    */      
    void changeCPI(int cpi);
    
   /** Set new operating frequency to the mouse chip.
    * 
    * @param freq A int value between 500000 and 2000000 for the SPI frequency(in MHz)
    */
    void set_freq(int freq);
    
   /** Chip Power Down.
    */
    void end();
    
   /** Chip Power Up.
    */
    void start();
    
private:
    int cread(unsigned char cregister);
    void cwrite(unsigned char caddress, unsigned char cdata);
    int MChipMotion(int reading);
    void creset();
    
    SPI spi_;
    DigitalOut npd_;
    DigitalOut reset_;
    DigitalOut ncs_;
};

#endif
