#include "ADNS6010.h"

ADNS6010::ADNS6010(PinName mosi, PinName miso, PinName sclk, PinName ncs, PinName reset,PinName npd)
        : spi_(mosi, miso, sclk), npd_(npd),reset_(reset), ncs_(ncs) {
    spi_.format(8,3);
    spi_.frequency(500000);

    // Chip Reset
    creset();
    start();
   
    npd_ =1;
    wait_ms(1);

    int prod_id = cread(REGISTER_PRODUCTID); // read Product ID register
    int rev_id = cread(REGISTER_REVISONID); // read Revision ID register

    if ((prod_id!=ADNS6010_PRODUCTID)||(rev_id!=ADNS6010_REVISIONID)) {
        error("The connection with the ADNS-6010 is not established\n");
    } 
    
}

// write data to a register
void ADNS6010::cwrite(unsigned char caddress, unsigned char cdata) {
    ncs_=0;
    // send the command to read the register
    caddress |= 0x80;
    spi_.write(caddress);
    // send dummy byte
    spi_.write(cdata);
    ncs_=1;
    
    wait_us(10); // more than the minimum for safety
}


// mouse chip - change resolurion
void ADNS6010::changeCPI(int cpi) {
    int config = 0x49;//resolution reset(=default=400)
    
    switch (cpi) {
        case 400:
            //config = config & 0x49
            break;
            
        case 800: // Change cpi to 800
            config |= 0x10;
            break;

        case 1600: // Change cpi to 1600
            config |= 0x04;
            break;

        case 2000: // Change cpi to 2000
            config |= 0x14;
            break;

        default:
            error("setting fault\n cpi setting is only 400 or 800 or 1600 or 2000\n\r");
            break;
    }
    
    cwrite(REGISTER_CONFIGURATION_BITS,config);
}


void ADNS6010::end()
{
    npd_=0;
}

void ADNS6010::start()
{
    npd_=1;
}

void ADNS6010::creset()
{
    reset_ = 1;
    wait_us(10);
    reset_ = 0;
}

void ADNS6010::set_freq(int freq)
{
    if(freq>=500000&&freq<=2000000)
    {
        spi_.frequency(freq);
    }
}

int ADNS6010::read_squal()
{
    return cread(REGISTER_SQUAL)*4;
}

// read the delta_X and delta_Y of the chip
void ADNS6010::read_deltas(int* a_dx, int* a_dy) {

    int * dx, * dy;
    dx=(int*)a_dx;
    dy=(int*)a_dy;
    *dx = 0;
    *dy = 0;

    int motion = cread(REGISTER_MOTION); // read Motion register
    
    if ((motion&0x80)==0x80) {
        *dx = MChipMotion(cread(REGISTER_DELTAX));
        *dy = MChipMotion(cread(REGISTER_DELTAY));
    }
}

// read a register
int ADNS6010::cread(unsigned char cregister) {

    ncs_=0;
    // send the command to read the register
    spi_.write(cregister);
    
    if(cregister==REGISTER_MOTION)  wait_us(DELAY_TRAD_MOT);
    else                            wait_us(DELAY_TRAD);
    
    // send dummy byte
    int reply = spi_.write(0x00);
    ncs_=1;
    
    return reply;
}

// Transform the reading of the mouse Delta register to actual motion
int ADNS6010::MChipMotion(int reading) {

    int displacement;
    if (reading <= 0x7f) {
        displacement = reading;
    } else {
        displacement = reading - 256;
    }
    return displacement;
}