#include "mbed.h"
#include "AD128160.h"

AD128160 lcd(p9,p20);

int rgb565(int r, int g,int b) {
    int rgb;

    rgb = (r & 0xF8) << 8;        /* RRRRR----------- */
    rgb |= (g & 0xFC) << 3;       /* -----GGGGGG----- */
    rgb |= b >> 3;                /* -----------BBBBB */

    return rgb;
}

int main() {
    lcd.textBackground(1,rgb565(255,0,0));
    
    lcd.locate(2,lcd.rows()/2);
    lcd.printf("Hello World!\n");

    lcd.color(rgb565(0,255,0));
    lcd.box(12,76,116,100,0);
    lcd.box(8,120,124,146,1);

    lcd.color(rgb565(255,0,0));
    lcd.circle(16,40,16,0);
    lcd.circle(48,40,16,1);
    lcd.circle(80,40,16,1);
    lcd.circle(112,40,16,0);
}
