#include "mbed.h"
#include "AD128160.h"

#define DATA_SIZE 128*128

LocalFileSystem local("local");
AD128160 lcd(p9,p20);

int rgb565(int r, int g,int b)
{
    int rgb;
    
    rgb = (r & 0xF8) << 8;        /* RRRRR----------- */
    rgb |= (g & 0xFC) << 3;       /* -----GGGGGG----- */
    rgb |= b >> 3;                /* -----------BBBBB */
    
    return rgb;
}

int main() {
    FILE *fpi;
    int i;
    unsigned char  idat;
    unsigned char dat,dat2;
    //lcd.speed(115200);
    //lcd.speed(230400);
    lcd.speed(460800);

    if ((fpi=fopen("/local/sample.bmp", "rb")) == NULL) {
        fprintf(stderr, "input file open error\n");
        exit(1);
    }
    
    for (i=0;i<0x46;i++)//bitmap headder throw
        fread(&idat, sizeof(unsigned char), 1, fpi);
        
    for(int i=0;i<128;i++){
        for(int j=0;j<128;j++){
        fread(&dat, sizeof(unsigned char), 1, fpi);
        fread(&dat2, sizeof(unsigned char), 1, fpi);

        int rgb=dat | dat2<<8;
        lcd.color(rgb);
        lcd.pixel(i,j);
        }
    }
    
}
