#include "AD128160.h"

AD128160::AD128160(PinName tx,PinName reset):_device(tx,NC),_rst(reset) {
    init();
}

void AD128160::init() {
    reset();
    brightness(300);
    cls();
    locate(0,0);
    color(0xffff);

    _font_x=8;
    _font_y=16;
    _max_columns = LCD_WIDTH/_font_x;
    _max_rows = LCD_HEIGHT/_font_y;
}

int AD128160::_putc(int c) {
    if (c == '\n') {
        newline();
    } else {
        int x = _column * _font_x;  // FIXME: Char sizes
        int y = _row * _font_y;
        unsigned char data[5];

        data[0]= x >> 8;//x upper 8bit
        data[1]= x & 0xFF;//x low 8bit
        data[2]= y >> 8; //y upper 8bit
        data[3]=y & 0xFF; //y low 8bit
        data[4]=c;
        cwrite(0x0B,data,5);

        _column++;
        if (_column >= _max_columns) {
            _row++;
            _column = 0;
        }
        if (_row >= _max_rows) {
            _row = 0;
        }
    }
    return c;
}
void AD128160::textSetting(int size,int rgb) {
    unsigned char data[4];

    data[0]= size >> 8;//x upper 8bit
    data[1]= size & 0xFF;//x low 8bit
    data[2]= rgb >> 8; //y upper 8bit
    data[3]= rgb & 0xFF; //y low 8bit

    cwrite(0x81,data,4);

    switch (size) {
        case 0:
            _font_x=6;
            _font_y=10;
            break;
        case 1:
            _font_x=7;
            _font_y=13;
            break;
        case 3:
            _font_x=10;
            _font_y=20;
            break;
        case 4:
            _font_x=16;
            _font_y=32;
            break;
        default:
            _font_x=8;
            _font_y=16;
            break;
    }
    _max_columns = LCD_WIDTH/_font_x;
    _max_rows = LCD_HEIGHT/_font_y;
    
    locate(0,0);
}


void AD128160::cwrite(int command,unsigned char* data,int length) {
    unsigned char sum=0;
    _device.putc(0x55);//start code
    _device.putc(length+1);
    _device.putc(command);
    for (int i=0; i<length; i++) {
        _device.putc(data[i]);
        sum = sum+data[i];
    }
    sum += command;
    _device.putc(sum);//check sum
    _device.putc(0xAA);//end core
}

void AD128160::brightness(int value) {
    unsigned char data[2];
    data[0] = (value & 0xff00)>>8;
    data[1] = value & 0x00ff;

    cwrite(0x89,data,2);
}

void AD128160::reset() {
    _rst = 0;            //Reset
    wait(0.1);
    _rst = 1;
    wait(0.1);
}


void AD128160::speed(int baud) {
    unsigned char data[4];

    data[0]=(baud&0xff000000)>>24;
    data[1]=(baud&0x00ff0000)>>16;
    data[2]=(baud&0x0000ff00)>>8;
    data[3]=baud&0x000000ff;

    cwrite(0x8B,data,4);

    wait(0.1);
    _device.baud(baud);

}

int AD128160::width() {
    return LCD_WIDTH;
}

int AD128160::height() {
    return LCD_HEIGHT;
}

int AD128160::columns() {
    return _max_columns;
}

int AD128160::rows() {
    return _max_rows;
}

void AD128160::bmp(int x0,int y0,int bmp_no) {
    unsigned char data[6];

    data[0] = x0 >> 8;
    data[1] = x0 & 0xFF;
    data[2] = y0 >> 8;
    data[3] = y0 & 0xff;
    data[4] = bmp_no >> 8;
    data[5] = bmp_no & 0xFF;

    cwrite(0x09,data,6);
}

void AD128160::cls() {
    unsigned char data[1];
    data[0]=0x55;
    cwrite(0x80,data,1);

    locate(0,0);
}

void AD128160::locate(int column, int row) {
    _column = column;
    _row = row;
}

void AD128160::puts(char* s) {
    int data_len=strlen(s)+4;
    unsigned char data[data_len];
    int x = _column * _font_x;  // FIXME: Char sizes
    int y = _row * _font_y;

    data[0] = x >> 8;
    data[1] = x & 0xFF;
    data[2] = y >> 8;
    data[3] = y & 0xFF;

    strcpy((char*)(data+4),s);
    cwrite(0x0B,data,data_len);
}

void AD128160::textBackground(bool mode,int rgb) {
    unsigned char data[3];

    if (mode) data[0]=1;
    else     data[0]=0;
    data[1]=(rgb >> 8) & 0xff;
    data[2]=(rgb & 0xff);
    cwrite(0x85,data,3);
}

void AD128160::color(int rgb) {
    unsigned char data[2];

    data[0]=(rgb >> 8) & 0xff;
    data[1]=(rgb & 0xff);
    cwrite(0x84,data,2);
}

void AD128160::newline(void) {
    _column = 0;
    _row++;

    if (_row >= _max_rows) {
        _row = 0;
    }
}

void AD128160::pixel(int x0,int y0) {
    unsigned char data[4];

    data[0] = x0 >> 8;
    data[1] = x0 & 0xFF;
    data[2] = y0 >> 8;
    data[3] = y0 & 0xff;

    cwrite(0x01,data,4);
}

void AD128160::box(int x0,int y0,int x1,int y1,int paint) {
    unsigned char data[8];

    data[0] = x0 >> 8;
    data[1] = x0 & 0xFF;
    data[2] = y0 >> 8;
    data[3] = y0 & 0xff;
    data[4] = x1 >> 8;
    data[5] = x1 & 0xFF;
    data[6] = y1 >> 8;
    data[7] = y1 & 0xff;

    if (paint)   cwrite(0x04,data,8);
    else        cwrite(0x03,data,8);
}

void AD128160::circle(int x0,int y0,int r,int paint) {
    unsigned char data[6];

    data[0] = x0 >> 8;
    data[1] = x0 & 0xFF;
    data[2] = y0 >> 8;
    data[3] = y0 & 0xff;
    data[4] = r >> 8;
    data[5] = r & 0xFF;

    if (paint)   cwrite(0x06,data,6);
    else        cwrite(0x05,data,6);
}

void AD128160::line(int x0,int y0,int x1,int y1) {
    unsigned char data[8];

    data[0] = x0 >> 8;
    data[1] = x0 & 0xFF;
    data[2] = y0 >> 8;
    data[3] = y0 & 0xff;
    data[4] = x1 >> 8;
    data[5] = x1 & 0xFF;
    data[6] = y1 >> 8;
    data[7] = y1 & 0xff;

    cwrite(0x02,data,8);
}
