#ifndef AD128160_H_
#define AD128160_H_

#include "mbed.h"

//#define LCD_ROWS 10
//#define LCD_COLS 16
#define LCD_WIDTH 128
#define LCD_HEIGHT 160
/** An interface for the AD128160 LCD display
 *
 */
 
class AD128160: public Stream {
public:
    /** Create and AD128160 interface, using a tx and one DigitalOut interfaces
     *
     * @param tx A serialport(tx)
     * @param reset A DigitalOut
     */
    AD128160(PinName tx,PinName reset);
    
    /** Set a pixel on te screen
    *
    * @param x horizontal position from left
    * @param y vertical position from top
    */
    void pixel(int x0,int y0);
    
    /** Draw a box on the screen
    *
    * @param x0 start point of box(X)
    * @param y0 start point of box(Y)
    * @param x1 end point of box(X)
    * @param y1 end poinrt of box(Y)
    * @param paint Setting the fill.If set of 1, fill of box.
    */
    void box(int x0,int y0,int x1,int y1,int paint);
    
    /** Draw a line on the screen
    *
    * @param x0 start point of line(X)
    * @param y0 start point of line(Y)
    * @param x1 end point of line(X)
    * @param y1 end point of line(Y)
    */
    void line(int x0,int y0,int x1,int y1);
    
    /** Draw a circle on the screen
    *
    * @param x0 center point of circle(X)
    * @param y0 centor point of circle(Y)
    * @param r circle of radius
    * @param paint Setting the fill.If set of 1, fill of circle.
    */
    void circle(int x0,int y0,int r,int paint);
    
    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(int column, int row);  

    /** Configure of the LCD's back light blightness
     *
     * @param value brightness value. range of 0-500
     */ 
    void brightness(int value);

    /** Set a color
    *
    * @param rgb 2byte colour in format RGB:56
    */
    void color(int rgb);

    /** Setting a text back ground
    *
    * @param mode   If mode is true,text'backgroud is on.
    * @param rgb  2byte colour in format RGB:565
    */
    void textBackground(bool mode,int rgb);
    
    /** Configure of the LCD speed
    *
    * @param baud baudrate of the LCD
    */
    void speed(int baud);

    /** Clear the screen and locate to 0,0 */
    void cls();

    /** Reset of the LCD */
    void reset();

    /** Write a string to the LCD
     *
     * @param s The string to write to the display
     */
    void puts(char* s);
    
    /** Setting a text size and color.If this function, column and row is 0,0.
     * 
     * @param size text size(0:6x10 1:7x13 2:8x16 3:10x20 4:16x32)
     * @param rgb  2byte colour in format RGB:565
     */
    void textSetting(int size,int rgb);
    
#if DOXYGEN_ONLY
    /** Write a character to the LCD
     *
     * @param c The character to write to the display
     */
    int putc(int c);

    /** Write a formated string to the LCD
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string.
     */
    int printf(const char* format, ...);
#endif
    /** get of the LCD width
    *
    * @return LCD width
    */
    int width();
    
    /** get of the LCD height
    *
    * @return LCD height
    */
    int height();
    
    /** get of the LCD colums
    *
    * @return LCD colums
    */
    int columns();
    
    /** get of the LCD rows
    *
    * @return LCD rows
    */
    int rows();

    void bmp(int x0,int y0,int bmp_n);
    
protected:
void init();
    void newline();
    void cwrite(int command,unsigned char* data,int length);
    virtual int _putc(int c);
    virtual int _getc() {
        return 0;
    }

    Serial _device;  // tx
    DigitalOut _rst;     // LCD  RST  (Reset)
    int _row, _column;//now row and col
    int _font_x,_font_y;//font size
    int _max_columns,_max_rows;//max row and col

};


#endif