#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "Motor.h"
#include "uLCD_4DGL.h"
#include<string>
#include<iostream>
#include<sstream>
using namespace std;

Serial pc(USBTX,USBRX);
Motor m(p22, p28, p21); // pwm, fwd, rev
DigitalIn pin_up(p13);
DigitalIn pin_down(p14);
DigitalIn pin_menu(p15);
DigitalIn pin_enter(p16);
uLCD_4DGL lcd(p9, p10, p11); // create a global lcd object
// Internet of Things clock example: LCD time is set via internet NTP time server
EthernetNetIf eth;
DigitalOut led(LED1);
NTPClient ntp;
DigitalIn pin(p20);

int main() {
    pc.printf("beginning");
    m.speed(1);
    pin_up.mode(PullUp);
     pin_down.mode(PullUp);
      pin_menu.mode(PullUp);
       pin_enter.mode(PullUp);
    
//system time structure
    time_t ctTime;
    char *time_str;
    //clear LCD
    lcd.cls();
    lcd.locate(0,2);
    // lcd.printf prints to LCD display;
    lcd.printf("Get IP addr...");
    EthernetErr ethErr = eth.setup();
    //Get an Internet IP address using DHCP
    if (ethErr) {
        //error or timeout getting an IP address
        lcd.cls();
        lcd.locate(0,2);
        lcd.printf("Net Error %d",ethErr);
        return -1;
    }
    lcd.locate(0,3);
    lcd.printf("Reading Time...");
    //specify time server URL
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    //Read time from server
    ntp.setTime(server);
    lcd.locate(0,4);
    lcd.printf("Time set");
    //Delay for human time to read LCD display
    wait(1);
    float motor_speed=1.0;
    int start_time_hr=14;
    int start_time_min=0;
    int end_time_hr=21;
    int end_time_min=0;
    while (1) {
        // loop and periodically update the LCD's time display
        
        if(pin_menu==0)
        {
            lcd.cls();
            lcd.color(LGREY);
            lcd.printf("Start time:\n%d hour  ",start_time_hr);
            while(1)
            {
                lcd.color(GREEN);
                if(pin_up==0)
                {
                       
                       start_time_hr=(start_time_hr+1) % 24;
                       lcd.locate(0,1);
                       lcd.printf("%d hour  ",start_time_hr);
                       wait(2);
                }   
                else if(pin_down==0)
                {
                        if(start_time_hr==0)
                            start_time_hr=23;
                        else
                            start_time_hr=(start_time_hr-1) % 24;   
                        lcd.locate(0,1);
                       lcd.printf("%d hour  ",start_time_hr);
                       wait(2);
                }
                else if(pin_enter==0)
                {
                    wait(2);
                    break;   
                }    
            }       
            lcd.locate(0,1);
            lcd.printf("%d min     ",start_time_min);
            while(1)
            {
                if(pin_up==0)
                {
                       start_time_min=(start_time_min+1) % 60;
                       lcd.locate(0,1);
                       lcd.printf("%d min       ",start_time_min);
                       wait(2);
                }   
                else if(pin_down==0)
                {
                        if(start_time_min==0)
                            start_time_min=59;
                        else
                            start_time_min=(start_time_min-1) % 60;   
                       lcd.locate(0,1);
                       lcd.printf("%d min       ",start_time_min);
                        wait(2);
                }
                else if(pin_enter==0)
                {
                    wait(2);
                    break;   
                }    
            }       
            lcd.cls();
            lcd.color(LGREY);
            lcd.printf("End time:\n%d hour",end_time_hr);
            while(1)
            {
                lcd.color(GREEN);
                if(pin_up==0)
                {
                       end_time_hr=(end_time_hr+1) % 24;
                       lcd.locate(0,1);
                       lcd.printf("%d hour    ",end_time_hr);
                        wait(2);
                }   
                else if(pin_down==0)
                {
                        if(end_time_hr==0)
                            end_time_hr=23;
                        else
                            end_time_hr=(end_time_hr-1) % 24;   
                       lcd.locate(0,1);
                       lcd.printf("%d hour    ",end_time_hr);
                       wait(2);
                }
                else if(pin_enter==0)
                {
                    wait(2);
                    break;   
                }    
            }     
            lcd.locate(0,1);
            lcd.printf("%d min    ",end_time_min);  
            while(1)
            {
                if(pin_up==0)
                {
                       end_time_min=(end_time_min+1) % 60;
                       lcd.locate(0,1);
                       lcd.printf("%d min       ",end_time_min);
                        wait(2);
                }   
                else if(pin_down==0)
                {
                        if(end_time_min==0)
                            end_time_min=59;
                        else
                            end_time_min=(end_time_min-1) % 60;   
                       lcd.locate(0,1);
                       lcd.printf("%d min       ",end_time_min);
                        wait(2);
                }
                else if(pin_enter==0)
                {
                    wait(2);
                    break;   
                }    
            }
            lcd.cls();
            lcd.color(LGREY);
            lcd.printf("Motor speed: \n%2.1f (normalized)",motor_speed);
            while(1)
            {
               lcd.color(GREEN);
                if(pin_up==0)
                {
                       if(motor_speed==1.0)
                            motor_speed=1.0;
                       else
                            motor_speed=motor_speed+0.1;
                       
                       lcd.locate(0,1);
                       lcd.printf("%2.1f (normalized)",motor_speed);
                        wait(2);
                }   
                else if(pin_down==0)
                {
                          if(motor_speed==0.0)
                            motor_speed=0.0;
                       else
                            motor_speed=motor_speed-0.1;
                       
                       lcd.locate(0,1);
                       lcd.printf("%2.1f (normalized)",motor_speed);
                        wait(2);
                }
                else if(pin_enter==0)
                {
                    wait(2);
                    break;   
                }    
            }       
        }
                
        
        led=pin;
        lcd.cls();
        ctTime = time(NULL);
        lcd.locate(0,1);
        lcd.color(LGREY);
        lcd.printf("Current time(UTC):");
        lcd.color(GREEN);
        lcd.locate(0,3);
        time_str = ctime(&ctTime);
        time_str[strlen(time_str)-1] = 0;
        lcd.printf("%s\n", time_str);
        string s(time_str);
        int ind=s.find(":");
        char* bh; 
        bh[0]=s[ind-2];
        bh[1]=s[ind-1];
        bh[2]=0;
        int hour=atoi(bh);
        char* b;
        b[0]=s[ind+1];
        b[1]=s[ind+2];
        b[2]=0;
        int min=atoi(b);
        lcd.color(LGREY);
        lcd.printf("\nMotor run time:\n");
        lcd.color(GREEN);
        lcd.printf("%d:%d to %d:%d (UTC)\n \n",start_time_hr,start_time_min,end_time_hr,end_time_min);
        time(&ctTime);
        struct tm *tmp = gmtime(&ctTime);
        lcd.color(LGREY);
        pc.printf("hour: %d min: %d",hour,min); 
        if((hour>start_time_hr && hour<end_time_hr))
        {       
                m.speed(motor_speed);
                lcd.color(LGREY);
                lcd.printf("Motor running \n");
                lcd.color(GREEN);
                lcd.printf("Speed=%2.1f\n",motor_speed);
        } 
        else if((hour==start_time_hr && hour==end_time_hr && min>=start_time_min && min<=end_time_min))
        {       
                m.speed(motor_speed);
                 lcd.color(LGREY);
                lcd.printf("Motor running \n");
                lcd.color(GREEN);
                lcd.printf("Speed=%2.1f\n",motor_speed);
        }    
        else if(hour==start_time_hr && hour<end_time_hr && min>=start_time_min)
        {       
                 m.speed(motor_speed);
               lcd.color(LGREY);
                lcd.printf("Motor running \n");
                lcd.color(GREEN);
                lcd.printf("Speed=%2.1f\n",motor_speed);
        }    
        else if(hour==end_time_hr && hour>start_time_hr && min<=end_time_min)
        {       
                 m.speed(motor_speed);
                 lcd.color(LGREY);
                lcd.printf("Motor running \n");
                lcd.color(GREEN);
                lcd.printf("Speed=%2.1f\n",motor_speed);
        }    
        else
        {       
                 m.speed(0);
                 lcd.color(LGREY);
                lcd.printf("Motor stopped\n");
                
        }    
        
        wait(5);
    }
}
