#include "mbed.h"
#include "AS7265xfunctions.h"
#include "SDFileSystem.h"
#include "ExtendedTimer.h"
I2C i2c(p28, p27);
AS7265x lightSensor(i2c, 0x92);
Serial pc(USBTX,USBRX);
DigitalOut led600(p17);
DigitalOut led405(p18);
DigitalOut ledWhite(p24);
DigitalOut led255(p25);
/* DigitalOut testLed1(LED1);
DigitalOut testLed2(LED2);
DigitalOut testLed3(LED3);
DigitalOut testLed4(LED4); */
DigitalOut powerLed(p16);
DigitalOut SD_indicator(p15);
SDFileSystem fs(p5, p6, p7, p8, "fs");
ExtendedTimer currentTimeT;
Timer sdReset;
AnalogIn UVSensor(p20);
bool computerPrint = false;

int main() {
    powerLed = 1;
    bool mountFailure = fs.mount();
    if (mountFailure != 0) {
        if(computerPrint) {
        pc.printf("Failed to mount\r\n"); }
        return -1;
    }
    FILE* fp = fopen("/fs/log.txt","a");
    if(fp == NULL) {
        if(computerPrint) {
        pc.printf("Failed to open file\r\n"); }
        fs.unmount();
        return -1;
    }
    FILE* fpuv = fopen("/fs/uvlog.txt","a");
    FILE* fpnone = fopen("/fs/uvnone.txt","a");
    SD_indicator = 1;
    fprintf(fp, "\r\nStarting New Session \r\n");
    fprintf(fpuv, "\r\nStarting New Session \r\n");
    
    float dt=1;
    wait(dt);
    lightSensor.setBank(2); //gather data from all channels
    lightSensor.setGain(3); //maximum gain
    lightSensor.setAllLeds(0);
    lightSensor.setIntegTime(711); //maximum integration time
    fprintf(fp, "LED \t Time \t 1 \t 2 \t 3 \t 4 \t 5 \t 6 \t 7 \t 8 \t 9 \t 10 \t 11 \t 12 \t 13 \t 14 \t 15 \t 16 \t 17 \t 18 \r\n");
    fprintf(fpuv, "Time \t UV Reading\r\n");
    fprintf(fpnone, "Time \t UV Reading\r\n");
    if(computerPrint) {
        pc.printf("LED \t Time \t \t UV Sensor \t 1 \t 2 \t 3 \t 4 \t 5 \t 6 \t 7 \t 8 \t 9 \t 10 \t 11 \t 12 \t 13 \t 14 \t 15 \t 16 \t 17 \t 18 \r\n");
    }
    currentTimeT.reset();
    currentTimeT.start();
    sdReset.start();
    while(currentTimeT < 18000){
            pc.printf("Beginning of while loop\r\n");
            if(currentTimeT > 600) {
                SD_indicator = 0;
                powerLed = 0;
            }
            for (int q = 0; q < 5; q++) { //toggling between each LED, reading data once in each LED configuration
                switch(q) {
                    case 0: led600 = 1; led405 = 0; ledWhite = 0; led255 = 0;
                    if(computerPrint == 1) {
                    pc.printf("600nm \t"); }
                    fprintf(fp, "600nm \t");
                    break;
                    case 1: led600 = 0; led405 = 1; ledWhite = 0; led255 = 0;
                    if(computerPrint == 1) {
                    pc.printf("405nm \t"); }
                    fprintf(fp, "405nm \t");
                    break;
                    case 2: led600 = 0; led405 = 0; ledWhite = 1; led255 = 0;
                    if(computerPrint == 1) {
                    pc.printf("White \t"); }
                    fprintf(fp, "White \t");
                    break;
                    case 3: led600 = 0; led405 = 0; ledWhite = 0; led255 = 1;
                    if(computerPrint == 1) {
                    pc.printf("255nm \t"); }
                    break;
                    case 4: led600 = 0; led405 = 0; ledWhite = 0; led255 = 0;
                    if(computerPrint == 1) {
                    pc.printf("none \t"); }
                    fprintf(fp, "none \t");
                    break;
                    default: led600 = 1; led405 = 1; ledWhite = 1; led255 = 1;
                    if(computerPrint == 1) {
                    pc.printf("Resorting to default\r\n"); }
                    fprintf(fp, "Resorting to default\r\n");
                }
                wait(dt);
                double x = 0;
                for(int i = 0; i < 10; i++) {
                    x = x + UVSensor.read();
                }
                double reading = x/10.0;
                if(q == 3) {
                    fprintf(fpuv, "%f \t %f\r\n",currentTimeT.read(), reading);
                }
                if(q == 4) {
                    fprintf(fpnone, "%f \t %f\r\n",currentTimeT.read(), reading);
                }
                if(computerPrint) {
                pc.printf("%f \t",currentTimeT.read()); }
                if(computerPrint) {
                pc.printf("%f \t",reading); }
                lightSensor.collectData(); //collect data and print all 18 channels each time data is taken from each LED
                for (int i = 1; i <19; i++) {
                    fprintf(fp, "%f \t %d \t",currentTimeT.read(), lightSensor.readData(i));
                    if(computerPrint == 1) {
                    pc.printf("%d \t",lightSensor.readData(i)); }
                }
                if(computerPrint == 1) {
                pc.printf("\r\n"); }
                fprintf(fp, "\r\n");
                wait(dt);
                if(sdReset > 600) {
                    fclose(fp);
                    fclose(fpuv);
                    fclose(fpnone);
                    wait(0.1);
                    fp = fopen("/fs/log.txt","a");
                    fpuv = fopen("/fs/uvlog.txt","a");
                    fpnone = fopen("/fs/uvnone.txt","a");
                    sdReset.reset();
                    pc.printf("SD was reset\r\n");
                }
            }
    }
    fclose(fp);
    fs.unmount();
}