#include <mbed.h>
#include "AS7265xfunctions.h"
#include "SDFileSystem.h"
I2C i2c(p9, p10);
AS7265x lightSensor(i2c, 0x92);
SDFileSystem fs(p5, p6, p7, p8, "fs");
Serial pc(USBTX,USBRX);
DigitalOut led600(p18);
DigitalOut led405(p19);
DigitalOut ledWhite(p20);
AnalogIn   uvSensor(p17);

int main() {
        // Mount the filesystem
    bool mountFailure = fs.mount();
    if (mountFailure != 0) {
        pc.printf("Failed to mount the SD card.\r\n");
        return -1;  // ends program with error status
    }
    FILE* fp = fopen("/fs/log.txt","w");
    if (fp == NULL) {
        pc.printf("Failed to open the file.\r\n");
        fs.unmount();
        return -1;
    } 
    // Write a header row 
    fprintf(fp, "Time (s) \t Light Reading\r\n");

    float dt=2;
    lightSensor.setBank(2);
    lightSensor.setGain(3);
    lightSensor.setAllLeds(0);
    lightSensor.setIntegTime(711);
    Timer time;
    
    while(time < 45){

        for (int q = 0; q < 4; q++) {
            switch(q) {
                case 0: led600 = 1; led405 = 0; ledWhite = 0;
                pc.printf("Orange LED\r\n");
                break;
                case 1: led600 = 0; led405 = 1; ledWhite = 0;
                pc.printf("Purple LED\r\n");
                break;
                case 2: led600 = 0; led405 = 0; ledWhite = 1;
                pc.printf("White LED\r\n");
                break;
                case 3: led600 = 0; led405 = 0; ledWhite = 0;
                pc.printf("LEDs Off\r\n");
                break;
                default: led600 = 1; led405 = 1; ledWhite = 1;
            }
            wait(dt);
            lightSensor.collectData();
            for (int i = 1; i <19; i++) {
                fprintf(fp,"%d \t", lightSensor.readData(i));
                pc.printf("%d \t", lightSensor.readData(i));
            }
            fprintf(fp,"\r\n");
            pc.printf("\r\n");
            wait(dt);
        }
    }
        // Close the file and unmount the file system so the SD card is happy
    fclose(fp);
    fs.unmount();
}