#ifndef AS7265XFUNCTIONS_H
#define AS7265XFUNCTIONS_H
#include <mbed.h>
class AS7265x {
    public:
        char getDeviceType(); // used for testing, should give 0x40
        char getHardwareVersion(); // used for testing, should give 0x41
        void ledSwitch(int, int); //first number 0, 1, or 2 says which LED, second number either 0 or 1 turns it on or off
        void setIntegTime(int); //sets integration time in milliseconds
        void setAllLeds(int); //enter either 0 or 1 to set all LEDs on or off
        AS7265x(I2C i2c, int addr); //constructor function
        uint16_t readData(int); //enter a number 1 through 18 to read the data from one of the channels
        void collectData(void); //run this function to collect one set of data from all channels
        void setBank(int);
        float readTemp(void);
        void setGain(int);
    private:
        void selectDevice(int); //selects one of the 3 sensors, used in ledSwitch() and collectData()
        uint16_t getData(int); //gets data from one channel, used in collectData() to set up the _channels array with all of the data
        uint16_t _channels[18]; //stores data from collectData()
        void regWrite(char reg, char data);
        char regRead(char reg);
        I2C _i2c;
        int _addr;
};
#endif
