#if !defined(__RINGBUF_H__)
#define __RINGBUF_H__
#include "mbed.h"


/**
* プロトンデータとタイムスタンプを保持する
*
* RingBuf classで使う
*
*/
typedef struct {
    int sn;
    int ad[3]; // LSB
} RingBufType;

/**
* プロトンデータとタイムスタンプを保持するリングバッファclass
*
*/
class RingBuf {
public:
    RingBuf(int size);
    ~RingBuf();
    /**
    * リングバッファにデータを1つpush
    * @param *d データ構造体へのpinter
    */
    void push(RingBufType *d);
    /**
    * リングバッファからデータを1つpop
    * @return データ構造体へのpointerを返す。データが無い時はNULLを返す。
    */
    RingBufType* pop(void);
    /**
    * バッファ内にある読み出し可能なデータ数を返す
    */
    int len_get(void);
    /**
    * バッファ全体のサイズを返す
    */
    int size_get(void);
    /**
    * バッファをクリアする
    */
    void clear();
    /**
    * 最新のデータ位置
    */
    volatile int latest;
    /**
    * リングバッファから指定位置のデータを1得る
    * @return データ構造体へのpointerを返す。データが無い時はNULLを返す。
    */
    RingBufType* peek(int p);
private:
    int size;
    volatile int wp;
    volatile int rp;
    RingBufType *buf;
};

#endif
