#if !defined(__DEBUGPRINT_H__)
#define __DEBUGPRINT_H__

#define PDEBUG

#ifdef PDEBUG
// 0=ERROR 1=INFO 2=TRACE
#define _debugLevel 2   // 出力レベル設定 0=NONE 1=ERROR 2=ERROR/INFO 3=ERROR/INFO/TRACE
 #if 1 // colored terminal output using ANSI escape sequences
  #define COL(c) "\033[" c
 #else
  #define COL(c) 
 #endif
 #define DEF COL("39m")
 #define BLA COL("30m")
 #define RED COL("31m")
 #define GRE COL("32m")
 #define YEL COL("33m")
 #define BLU COL("34m")
 #define MAG COL("35m")
 #define CYA COL("36m")
 #define WHY COL("37m")
 // ERROR()INFO()はログファイルにもOUT
 #define ERROR(...)     (_debugLevel < 0) ? : ::printf(RED), ::printf(__VA_ARGS__), ::printf(DEF)
 #define TEST(...)                            ::printf(CYA), ::printf(__VA_ARGS__), ::printf(DEF)  
 #define INFO(...)      (_debugLevel < 1) ? : ::printf(GRE), ::printf(__VA_ARGS__), ::printf(DEF)
 // Timestampなし
 #define INFO_NT(...)      (_debugLevel < 1) ? : ::printf(GRE), ::printf(__VA_ARGS__), ::printf(DEF)

 #define TRACE(...)     (_debugLevel < 2) ? : ::printf(__VA_ARGS__)
 #define TRACE_LN(...)     (_debugLevel < 2) ? : ::printf(__VA_ARGS__), ::printf("\r\n");

 #define TRACE_VARI(v)   TRACE("vari %s=%d\r\n", #v, v)
 #define TRACE_VARF(v)   TRACE("varf %s=%f\r\n", #v, v)
 #define TRACE_VARS(v)   TRACE("vars %s=%s\r\n", #v, v)
#else
 
 #define ERROR(...) (void)0 // no tracing
 #define TEST(...)  (void)0 // no tracing
 #define INFO(...)  (void)0 // no tracing
 #define TRACE(...) (void)0 // no tracing
 #define TRACE_VARI(...) (void)0 // no tracing
 #define TRACE_VARS(...) (void)0 // no tracing

#endif

#endif
