#include "RingBuf.h"

RingBuf::RingBuf(int _size)
{
    buf = new RingBufType[_size];
    size = _size;
    wp = 0;
    rp = 0;
    latest = -1;
}
    
RingBuf::~RingBuf()
{
    delete [] buf;
}

void RingBuf::push(RingBufType *d)
{
    latest = wp;
    buf[wp++] = *d;
    wp %= size;
}
RingBufType* RingBuf::pop(void)
{
    if (rp == wp) return NULL;
    RingBufType *d = &buf[rp++];
    rp %= size;
    return d;
}
int RingBuf::len_get(void)
{
    int i = wp - rp;
    if (i < 0) i += size; 
    return i;   
}
int RingBuf::size_get(void)
{
    return size;
}
void RingBuf::clear(void)
{
    rp = 0;
    wp = 0;
}
RingBufType* RingBuf::peek(int p)
{
    if (p < 0 || p >= size) return NULL;
    return &buf[p];
}

