/*
 *  CQ出版 Interface 2014年10月号のC027(MAX-7Q)GPSテスト記事で使用したプログラム
 *  Naoya Takamura
 */
#include "mbed.h"
#include "GPS.h"

#define C027_USEONBOARD
#include "C027.h"
C027 c027;

#define TRACE     printf

int main(void)
{
    int ret;
    char buf[2048] = "";

    // USB debug output
    Serial pc(USBTX,USBRX);
    pc.baud(115200);
    
    wait_ms(1000);
    // 3G modem power off
    c027.mdmPower(false);
    // GPS power on
    c027.gpsPower(true);
    wait(2);
    // Create gps object    
    GPSI2C gps(GPSSDA,GPSSCL,GPSADR); 

    // Serial out for Logomatic    
    Serial pc2(P4_28, P4_29);
    pc2.baud(9600);
    
    const int wait = 100;
    bool abort = false;
    while (!abort) {
        while ((ret = gps.getMessage(buf, sizeof(buf))) > 0)
        {
            int len = LENGTH(ret);
//            TRACE("NMEA: %.*s\r\n", len-2, buf); 
//            pc2.printf("NMEA: %.*s\r\n", len-2, buf); 
            if ((PROTOCOL(ret) == GPSParser::NMEA) && (len > 6))
            {
                if (!strncmp("$GPGGA", buf, 6))
                {
                    double lat = 0, lon = 0;
                    double  utc;
                    char qual;
                    double hdop = 99.99;
                    double hsea = 99.99;
                    char    outbuf[256];
                    if (gps.getNmeaItem(1,buf,len,utc) && 
                        gps.getNmeaAngle(2,buf,len,lat) && 
                        gps.getNmeaAngle(4,buf,len,lon) && 
                        gps.getNmeaItem(8,buf,len,hdop) &&
                        gps.getNmeaItem(9,buf,len,hsea) &&
                        gps.getNmeaItem(6,buf,len,qual) && qual != 0)
                    {
                        sprintf(outbuf, "%06d,%.6f,%.6f,%.2f,%.1f\r\n", (long)utc, lat, lon, hdop, hsea); 
                        TRACE(outbuf);
                        pc2.printf(outbuf);
                    }
                }
            }
        }
        wait_ms(wait);
    }
    gps.powerOff();
    TRACE("Shutdown\r\n");
    c027.gpsPower(false);
    return 0;
}
