/*  Platform header file, for the u-blox C27-C20/U20/G35 
*   mbed Internet of Things Starter Kit
*   http://mbed.org/platforms/u-blox-C027/
*   
*/

#pragma once

#include "mbed.h"

#if !defined(TARGET_UBLOX_C027)
  #warning "this library is indended to be used only with the C027 board"
#else

//#define C027_REVA // select this define if you use revision A boards. 

/** C027 Helper class to control the power supply and interface 
    signals of the extended peripherials
*/
class C027
{
public:
    /** Constructor, this function initialized the control pins.
    */
    C027();

    /** Enable the power supply of the Modem (MDM)
    */
    void mdmPower(bool enable);
    
    /** Activate the Usb Interface on LISA-C or LISA-U modems. For LISA-C this 
        function must be called before its supply is enabled.
        \param enable true if supply should be truned on, false if off
    */
    void mdmUsbEnable(bool enable);
    
    /** Reset the Modem 
        \attention use with care and only a last resort.
    */
    void mdmReset(void);
    
    /** Wakeup the Modem when in off mode.
    */
    void mdmWakeup(void);
    
    /** Some Modem can be commanded in sleep mode 
        by setting the power pin low for a long period. 
    */
    void mdmSleep(void);
    
    /** Enable the GPS Power supply 
        \param enable true if supply should be truned on, false if off.
    */
    void gpsPower(bool enable);
    
    /** Reset the GPS
        \attention use with care and only a last resort.
    */
    void gpsReset(void);

private:
    // modem pins 
    DigitalOut      mdmEn;        //!< The modem LDO enable pin
    DigitalOut      mdmRst;       //!< The modem reset pin
    DigitalOut      mdmPwrOn;     //!< The power constrol pin of the modem
    DigitalOut      mdmLvlOe;     //!< The modem IO level shifter output enable (UART, GPIOs, active low)
    DigitalOut      mdmILvlOe;    //!< The modem I2C level shifter output enable (I2C, active high)
    DigitalOut      mdmUsbDet;    //!< The USB interface enable (active high)
    bool            mdmIsEnabled; //!< Flag to remember if modem was enabled
    bool            mdmUseUsb;    //!< Flag to remember if USB pins were enabled
    // gps pins
    DigitalOut      gpsEn;        //!< The GPS LDO enable pin
    DigitalOut      gpsRst;       //!< The GPS reset pin
    bool            gpsIsEnabled; //!< Flag to remember if GPS was enabled
};
#endif
