#include "mbed.h"
#include "rtos.h"
#include "C12832.h"

AnalogIn   port1(p19);
Serial pc(USBTX, USBRX);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn   port2(p20);
DigitalOut myled[] = {LED1,LED2,LED3,LED4};



int i, x = 1;

void knight_rider(void const *args) {
    while (true) {
        
        for(i=0; i<4; i++) {
            myled [i]=1;
            Thread::wait(100);
            myled [i]=0;
        }

        for(i=2; i>0; i--) {
            myled [i] = 1;
            Thread::wait(100);
            myled [i]=0;
            
        }
    
    }
}


void ADC_pc(void const *args) {
    
       int j=0; 
       
   printf("ADC with Interupt");

    while(true) {   // this is the third thread
      
        printf("Voltage : %3.3f  V",port1.read()*3.3);
        j++;
       Thread::wait(100);
        
    }
}

void ADC_lcd(void const *args) {
    
    
    int j=0;            //local variable
    lcd.cls();          //clear screen
    lcd.locate(0,3);    //point cursor
    lcd.printf("Voltage Measurement");

    while(true) {   // this is the third thread
       lcd.locate(0,20);
        lcd.printf("Voltage : %3.3f  V",port2.read()*3.3);
        j++;
        Thread::wait(1000);
        
    }
}
 
int main() {
    Thread tread1(knight_rider);
    Thread tread2(ADC_pc);
    Thread tread3(ADC_lcd);
    
    while (true) ;
}
