/**
  ******************************************************************************
  * @file    RMS_UART.cpp
  * @author  Surasak N
  * @version V2
  * @date    20/09/2016
  * @brief   Command for Mini-RMS <> RMS via UART
  ******************************************************************************/
  
#ifndef RMS_UART_H
#define RMS_UART_H

#define EXT_SERIAL              1
#define MSG_BUF_SIZE            25
#define MSG2CMD                 2
#define MSG2FILENAME            (MSG_BUF_SIZE - MSG2CMD)
#define CONTENT_BUF_SIZE        1536

#define CMD_END_OF_CONTENT      "*end*"
#define CMD_LISTFILE            "ls"
#define CMD_READFILE            "rd"
#define CMD_WRITEFILE           "ed"
#define CMD_DELETEFILE          "df"
#define CMD_SYS_RESTART         "rs"
#define CMD_SYS_PAUSE           "sp"
#define CMD_HELP                "-h"

#define FOUND_CSV_FILE          ".csv"
#define FOUND_XML_FILE          ".xml"
#define FOUND_LOG_FILE          ".log"

#define _SPACE                  '\0'
#define FLAG_STATUS_OK          "OK"
#define FLAG_STATUS_ERROR       "ER"
#define FLAG_STATUS_END         "*END*"


#define RMS_STATUS_LIST_OK      "LK"
#define RMS_STATUS_READ_OK      "RK"

#define EC_CMD_ERROR            "E1"
#define EC_FILE_NOT_FOUND       "E2"
#define EC_WRITE_ERROR          "E3"
#define EC_FILE_TOO_LARGE       "E4"

#define BPS_9600                9600

/** 
  * @brief  Command request definition  
  */ 
typedef enum {
    REQ_NONE,                   /** None Type    : UART do nothing */
    REQ_LISTDIR,                /** Connect Type : List files as in directory */
    REQ_READ,                   /** Read Type    : Read file as file name */
    REQ_WRITE,                  /** Write Type   : Create/Write as file name and contens */
    REQ_DELETE,                 /** Delete Type  : Delete file as file name */
    REQ_FLAG_OK,                /** Flag OK Type " Send "OK" flag via UART */
    REQ_READ_CHECK              /** Read Check Type : Check available file as in SD card */
} FileRequest_CMD_Type;

/* ###############  Declare functions extern ################## */
extern Serial serial_device;
extern FileRequest_CMD_Type reqFileCmdType;
extern char FileName[MSG2FILENAME];
extern char Content_RxBuf[CONTENT_BUF_SIZE + 1];
extern bool MsgContentManagement;

/* ###############  Function Prototype  ################## */
/** 
  * @note  The detail as RMS_UART.cpp  
  */ 
void Init_SerialDevice();              
void RxMsgInterruptCallback();
void DoTheMsgCmd();
void DoTheContent();
void GetListFileCmd();
void CheckReadEditCmd();
void GetFileName();
void SendContentToFile();
void GetCmdError();
void ClearCmdIndexAndBuf();
void ClearContentIndexAndBuf();
void CheckContentMsg();
void ClearFileNameBuf();
void CheckCmdType();
void ClearFileNameBuf();
void GetHelpCmd();

#endif /* End of RMS_UART_H */