#include "mbed.h"
#include <string.h>

#define MSG_BUF_SIZE            25
#define MSG2CMD                 2
#define MSG2FILENAME            (MSG_BUF_SIZE - MSG2CMD)
#define BPS9600                 9600


char Msg_RxBuf[MSG_BUF_SIZE+1];          // Reading Cmd Buffer 
int  Msg_index;                    // An Cmd index

char FileName[MSG2FILENAME];

bool RxInterruptEvent;

DigitalOut led1(LED1);
Serial serial_device(SERIAL_TX, SERIAL_RX);

void Init_SerialDevice();
void RxMsgInterrupt();
void CmdCallback();
void GetListFileCmd();
void CheckReadEditCmd();
void ReadCmdParaNotEnough();
void EditCmdParaNotEnough();

int main()
{
    RxInterruptEvent = 0;
    Init_SerialDevice();
    RxMsgInterrupt();
    
    while (1) {
        led1 = !led1;
        wait(0.5);
    }
}

/**
 * @brief   
 * @note 
 * @retval 
 */
void Init_SerialDevice()
{
    serial_device.baud(BPS9600);

}

/**
 * @brief   
 * @note 
 * @retval 
 */
void RxMsgInterrupt()
{
    /* Start Rx interrupt  */
    serial_device.attach(&CmdCallback);
}

 /**
 * @brief 
 * @note 
 * @retval
 */
void CmdCallback()
{
        
    // Note: you need to actually read from the serial to clear the RX interrupt
    Msg_RxBuf[Msg_index] = serial_device.getc();
    //serial_device.putc(Msg_RxBuf[Msg_index]);
    Msg_index++;
    
    if(strstr(Msg_RxBuf,"ls"))
    {
        GetListFileCmd();
    }
    
    if(strstr(Msg_RxBuf,".csv"))
    {
        CheckReadEditCmd();
    }
        
    if(strstr(Msg_RxBuf,".xml"))
    {
        CheckReadEditCmd();
    }
    
    if(strstr(Msg_RxBuf,".log"))
    {
        CheckReadEditCmd();
    }
    
    if(Msg_index >= 2)
    {
        if( !((strstr(Msg_RxBuf,"ls")) || (strstr(Msg_RxBuf,"rd")) || (strstr(Msg_RxBuf,"ed"))))
        {
            serial_device.printf("$?? -- Command Error\n",Msg_RxBuf+1);
            Msg_index = 0;
            memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
        }
    }
}

/**
 * @brief 
 * @note 
 * @retval
 */
void GetListFileCmd()
{   
    serial_device.printf("$ls -- list file command\n");
    Msg_index = 0;
    memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
}

/**
 * @brief 
 * @note 
 * @retval
 */
void CheckReadEditCmd()
{
    if(strstr(Msg_RxBuf,"rd"))
    {   
        serial_device.printf("$rd -- read command\n");
        memcpy(FileName,&Msg_RxBuf[3],(Msg_index - 3));
        serial_device.printf("FileName -- %s \n",FileName);
        Msg_index = 0;
        memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
    }
    else
    {
        Msg_index = 0;
        memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
    }
    
    if(strstr(Msg_RxBuf,"ed"))
    {
        serial_device.printf("$ed -- edit command\n");
        memcpy(FileName,&Msg_RxBuf[3],Msg_index - 3);
        serial_device.printf("FileName -- %s \n",FileName);
        Msg_index = 0;
        memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
    }
    else
    {
        Msg_index = 0;
        memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
    }
}

/**
 * @brief 
 * @note 
 * @retval
 */
void ReadCmdParaNotEnough()
{   
    serial_device.printf("$rd -- Paramiters not enough\n");
    Msg_index = 0;
    memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
}


/**
 * @brief 
 * @note 
 * @retval
 */
void EditCmdParaNotEnough()
{   
    serial_device.printf("$ed -- Paramiters not enough\n");
    Msg_index = 0;
    memset(Msg_RxBuf,' ',MSG_BUF_SIZE);
}