/*Final Design Project Main File || ECE 4180 Section B
Team members:
Nathan Weiss
Walter Ley
Srinivas Ravindran
*/

#include "mbed.h"
#include "rtos.h"
#include "PinDetect.h"
#include "MPL3115A2.h"
#include "LSM9DS1.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "RTC.h"
#include <stdlib.h>
#include <iostream>

uLCD_4DGL uLCD(p13,p14,p17); // serial tx, serial rx, reset pin;
I2C altI2C(p28,p27);
Serial pc(USBTX, USBRX);
MPL3115A2 sensor(&altI2C, NULL);
RawSerial dev(p9,p10);
LSM9DS1 lol(p28, p27, 0xD6, 0x3C);
SDFileSystem sd(p5,p6,p7,p8,"sd");
Altitude alt;
Temperature therm;
Mutex mut;
DigitalOut myled(LED1);
PwmOut red(p21); // Red led
PwmOut blue(p22); //blue led
PwmOut green(p23); // green LED

//Global variable declarations
volatile int stepCount = 0;
volatile bool yPassedMarker = true; //True if y passed 6000, false if y passed -6000
volatile float thermf = 0.0;
volatile float oldthermf = 0.0;
volatile float altf = 0.0;
volatile float minAltitude = 5000.0;
volatile float maxAltitude = 0.0;
volatile float minTemp = 1000.0;
volatile float maxTemp = 0.0;
char currDate[9];

void altSensor(void const *args){
    while(1){
        mut.lock();
        sensor.readAltitude(&alt);
        sensor.readTemperature(&therm);
        //pc.printf("Altitude: %sft, Temp: %sºF\r\n", alt.print(), therm.print());
        //pc.printf("OFF_H: 0x%X, OFF_T: 0x%X\r\n", sensor.offsetAltitude(), sensor.offsetTemperature());
        thermf = atof(therm.print());
        altf = atof(alt.print());
        if(thermf > maxTemp) {maxTemp=thermf;}
        if(thermf < minTemp) {minTemp=thermf;}
        if(altf > maxAltitude) {maxAltitude=altf;}
        if(altf < minAltitude) {minAltitude=altf;}
        
        //pc.printf("Max alt: %f, min alt: %f, max temp: %f, min temp: %f\n\r", maxAltitude, minAltitude, maxTemp, minTemp);
        mut.unlock();
        Thread::wait(2000);
    }
}

void stepCounter(void const *args){
    while(1){
        mut.lock();
        if(lol.accelAvailable()) {
            lol.readAccel();
                
            //Step if y alternates between +/-6000 while x < -3000
            if(lol.ax < -3000) {
                //pc.printf("accel: %d %d %d\n\r", lol.ax, lol.ay, lol.az);
                if(yPassedMarker && lol.ay < -600) {
                    stepCount++;
                    //pc.printf("Step!\n\r");
                    yPassedMarker = false;
                } else if (!yPassedMarker && lol.ay > 600) {
                    stepCount++;
                    //pc.printf("Step!\n\r");
                    yPassedMarker = true;
                }
            }
        }
        mut.unlock();
        Thread::wait(250);
    }
}

void readSD(char testDate[], bool isBluetooth){
    //Writes out the relevant data to the device
    //led4 = !led4;
    char data1[100];
    char data2[100];
    bool datePassed = false;
    bool data1Active = true;
    bool keepLooping = true;
    FILE *fp = fopen("/sd/mydir/info.txt", "r");    //Open file to append
    if(fp == NULL) {
        //uLCD.cls();
        pc.printf("Could not open file for read\n");
        return;
    }
    
    while(keepLooping) {
        //save the last string
        //read in string
        //if end of file, keep looping should be false
        if(data1Active) { 
            data1Active = false;
            memset(data2, 0, sizeof(data2));
            if (fgets (data2 , 100, fp) == NULL )
                keepLooping = false;
        } else {
            data1Active = true;
            memset(data1, 0, sizeof(data1));
            if (fgets (data1 , 100, fp) == NULL )
                keepLooping = false;
        }
        
        if(keepLooping) {
            //if the string contains the date and the date hasn't yet been found, mark the date as found
            if(data1Active) {
                if(!datePassed && (strstr(data1,testDate) != NULL)) {
                    datePassed = true;
                } else if(datePassed && strstr(data1, testDate) == NULL) { //if we have already found the date but now we've passed it, stop looping
                    keepLooping = false;
                }
            } else {
                if(!datePassed && (strstr(data2,testDate) != NULL)) {
                    datePassed = true;
                } else if(datePassed && strstr(data2, testDate) == NULL) { //if we have already found the date but now we've passed it, stop looping
                    keepLooping = false;
                }
            }
        }
    }
    fclose (fp);
    
    //At the end of the loop, the relevant data is in the pastData string
    if(datePassed) {
        //Parse the data in pastData and store it in the variables
        if(isBluetooth) {
            int pastStepCount = 0;
            float pastMinAlt = 0;
            float pastMaxAlt = 0;
            float pastMinTemp = 0;
            float pastMaxTemp = 0;
            char output[100];
            if(data1Active) {
                sscanf(data2, "%*s %*s %*s %i %*s %f %*s %f %*s %f %*s %f", &pastStepCount, &pastMinAlt, &pastMaxAlt, &pastMinTemp, &pastMaxTemp);
                pc.printf("Data Exists! And is %s", data2);
            } else {
                sscanf(data1, "%*s %*s %*s %i %*s %f %*s %f %*s %f %*s %f", &pastStepCount, &pastMinAlt, &pastMaxAlt, &pastMinTemp, &pastMaxTemp);
                pc.printf("Data Exists! And is %s", data1);
            } 
            sprintf(output, "\n\rFor %s:\n\rStep count - %i\n\rMinimum altitude - %5.2f\n\rMaximum altitude - %5.2f\n\rMinimum temp - %5.2f\n\rMaximum temp - %5.2f\n\r", testDate, pastStepCount, pastMinAlt, pastMaxAlt, pastMinTemp, pastMaxTemp);
            pc.printf("Bluetooth output:%s", output);
            dev.puts(output); 
        } else {
            if(data1Active) {
                //pc.printf("Data Exists! And is %s", data2);
                sscanf(data2, "%*s %*s %*s %i %*s %f %*s %f %*s %f %*s %f", &stepCount, &minAltitude, &maxAltitude, &minTemp, &maxTemp);
            } else {
                //pc.printf("Data Exists! And is %s", data1);
                sscanf(data1, "%*s %*s %*s %i %*s %f %*s %f %*s %f %*s %f", &stepCount, &minAltitude, &maxAltitude, &minTemp, &maxTemp);
            }
            /*minAltitude = 5000.0;
            maxAltitude = 0.0;
            minTemp = 5000.0;
            maxTemp = 0.0;*/
        }
    } else {
        //No prexisting data for that day, so load null data into the variables 
        if(isBluetooth) {
            //No data for that day
            char output[80];
            sprintf(output, "\n\rNo data available for %s.\n\r", testDate);
            pc.printf("Bluetooth output:%s", output); 
            dev.puts(output);
        } else {
            pc.printf("Data does not exist!\n\r");
            stepCount = 0;
        }
    }
    pc.printf("\n\rWatch stepcount = %i\n\r", stepCount);
}
void dev_recv(void const *args)
{
    char inputString[9];
    memset(inputString, 0, sizeof(inputString));
    int inputIndex = 0;
    while(1) {
        if(dev.readable()) {
            while(dev.readable()) {
                inputString[inputIndex] = dev.getc();
                inputIndex++;
                Thread::wait(100);
            }
            pc.printf("search for date:\n\r%s\n\r", inputString);
            readSD(inputString, true);
            memset(inputString, 0, sizeof(inputString));
            inputIndex = 0;
        }
    }
}

void updateSD(){
    mut.lock();
    FILE *fp = fopen("/sd/mydir/info.txt", "a");    //Open file to append
    if(fp == NULL) {
        //pc.cls();
        pc.printf("Could not open file for write\n");
    }
    fprintf(fp,"date: %s steps: %i min_alt: %5.2f max_alt: %5.2f min_temp: %5.2f max_temp: %5.2f\n\r", currDate, stepCount, minAltitude, maxAltitude, minTemp, maxTemp);
    fclose(fp);
    mut.unlock();
}

void temperatureRGB(void const *args){
    while(1){
       mut.lock();
         if (thermf > oldthermf && ((thermf-oldthermf)>0.5)) {
             red = 1.0;
             green = 0.0;
             blue = 0.0;
        } 
        else if (thermf < oldthermf && ((oldthermf-thermf)>0.5)) {
            red= 0.0;
            green = 0.0;
            blue =1.0;
        }
        else if (thermf < oldthermf && ((oldthermf-thermf)<=0.5) && ((oldthermf-thermf)>=0.15)) {
            red= 0.0;
            green =0.8;
            blue =0.6;
        }
        
        else if (thermf > oldthermf && ((thermf-oldthermf)<=0.5) && ((thermf-oldthermf)>=0.15)) {
             red = 0.6;
             green=0.8;
             blue = 0.0;
        }
        else {
            red=0.0;
            green=1.0;
            blue=0.0;
        }
        oldthermf = thermf;
        mut.unlock();
        Thread::wait(1500);
    }
}
    
void lcdDisplay(void const *args){
    while(1) {
        mut.lock();
        uLCD.locate(0,0);
        uLCD.filled_rectangle(50,66,128,128,BLACK);
        uLCD.filled_rectangle(0,0,128,64,WHITE);
        time_t seconds = time(NULL);
        
        //uLCD.locate(19,19);
        //time_t seconds = time(NULL);
       // uLCD.printf("%s", ctime(&seconds));
        //uLCD.printf("%s", time_buffer);
        //Print data
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.textbackground_color(BLACK);
        //uLCD.set_font(FONT_8X12);
        uLCD.color(BLUE);
        uLCD.locate(0,9);
        uLCD.printf("Steps: %*d", 5, stepCount);
        uLCD.color(GREEN);
        uLCD.locate(0,11);
        uLCD.printf("Alt: %*sft", 7, alt.print());
        uLCD.color(RED);
        uLCD.locate(0,13);
        uLCD.printf("Temp: %*sF", 6, therm.print());
        
        //Print time
        uLCD.locate(1,2);
        uLCD.textbackground_color(WHITE);
        uLCD.color(BLACK);
        //uLCD.set_font(FONT_8X12);
        uLCD.text_width(2);
        uLCD.text_height(2);
        //uLCD.text_bold(ON);
        //uLCD.printf("%s", ctime(&seconds));
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p", localtime(&seconds));
        uLCD.printf("%s", buffer);
        
        mut.unlock();
        Thread::wait(1000);
    }
}

int main(){
    pc.printf("Program starting!\n\r");
    myled = 0;
    uLCD.baudrate(3000000);
    sensor.init();
    wait_ms(300);
    sensor.setOffsetAltitude(113);
    sensor.setOffsetTemperature(20);
    
    //set_time(1460806560);
    
    //mkdir("/sd/mydir", 0777);
    time_t seconds = time(NULL);
    strftime(currDate, 9, "%m-%d-%y", localtime(&seconds));
    pc.printf("Today's date: %s\n\r", currDate);
    readSD(currDate, false);
    
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    lol.calibrate();
    
    uLCD.cls();
    uLCD.background_color(BLACK);
    
    red=0;//red=0;
    green=0; //green=0;
    blue=0; //blue=0;
    
    Thread th1(altSensor);
    Thread th2(stepCounter);
    Thread th3(lcdDisplay);
    Thread th4(temperatureRGB);
    Thread th5(dev_recv);
    
    while(1){
        pc.printf("Saving data!\n\r");
        myled != myled;
        Thread::wait(30000);
        updateSD();
    }
}