/* Copyright (c) 2021 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner
  that would cause the software to become subject to terms and conditions which
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors
  may be used to endorse or promote products derived from this software without
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or
  more patent holders.  This license does not release you from the requirement
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2021-01-10-7CBSD SLA
*/

/**
 * @file    gpio_config.cpp
 * @brief   This file interfaces configures test loads
 * @{
 */

/*=============  I N C L U D E S   =============*/
#include <stdlib.h>
#include "mbed.h"
#include "gpio_config.h"
#include "app_config.h"
#include "platform_drivers.h"

/*=============  D A T A  =============*/

static DigitalOut muxSelA(A2); // Aurdino p4.3
static DigitalOut muxSelB(A3); // Aurdino p4.4
static DigitalOut muxSelC(A4); // Aurdino p4.5
static DigitalOut muxEn(A5);   // Aurdino p4.6

// Declaring trigger input/output pins
// Setting trigger out to low by default
static DigitalOut trigOut(TRIGGER_OUT, 0);
static DigitalIn trigIn(TRIGGER_IN);

static bool triggerPolarity = 1;

/*=============  C O D E  =============*/

/**
 * @details     Enable demo test load corresponding to mux_sel
 * @param [in]  mux_sel - mux selection value
 * @return      0-Success, 1-Failure
 */
int32_t EnableMuxLine(int32_t muxSel)
{
    muxSelA = ((muxSel & 0x01));
    muxSelB = ((muxSel & 0x02) >> 1);
    muxSelC = ((muxSel & 0x04) >> 2);
    muxEn = 1;
    return 0;
}


/**
 * @}
 */
