#include "mbed.h"
#include "hcsr04.h"
#include "Servo.h"
#include "FXOS8700Q.h"
#include "math.h"
#define M_PI 3.1415926535

Serial pc(USBTX, USBRX);
Serial device (PTC15,PTC14);
HCSR04  usensor(A4,A5);
I2C i2c(PTE25, PTE24);
FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);
DigitalOut RED (LED1);
DigitalOut GREEN (LED2);
DigitalOut BLUE (LED3);
int distance;              //Variable to store distance from an object
int state = 0;
double pitch, roll;
const float alpha = 0.5;
double fxg = 0;
double fyg = 0;
double fzg = 0;
motion_data_counts_t acc_raw;
    
void filter_accelerometer()
{
    double xg, yg, zg;
    
    acc.getAxis(acc_raw);
    
    xg = acc_raw.x;
    yg = acc_raw.y;
    zg = acc_raw.z;
    
        // low pass filter
    fxg = xg * alpha + (fxg * (1.0 - alpha));
    fyg = yg * alpha + (fyg * (1.0 - alpha));
    fzg = zg * alpha + (fzg * (1.0 - alpha));

        // pitch and roll calculations
    roll  = (atan2(-fyg, fzg)*180.0)/M_PI;
    pitch = (atan2(fxg, sqrt(fyg*fyg + fzg*fzg))*180.0)/M_PI;
    printf(" %0.2f %0.2f \r\n", roll, pitch);
    }

int main()
{  
acc.enable();
    GREEN = 1;
    BLUE = 1;
    RED = 1;
    while(1) 
    {
        usensor.start();
        wait_ms(0.0025); 
        distance = usensor.get_dist_cm();
        wait(0.5);
        pc.printf(" distance = %d\r\n", distance);
        if(distance <= 9 )
        {
            device.printf("ALERT VEHICLE");  
        }
       filter_accelerometer();
       if (roll > 22.00 && pitch > 3.00 )
       {
         GREEN = BLUE = 1;
         RED = 0;
         
         wait(0.5);
         RED = 1;
       }
        if(device.readable() > 0) 
        {
            state = device.getc();
            pc.printf("Instruction: %i\n\r", state);    
        } 
        if (state == '1')
        {
            RED = BLUE = 1;
            GREEN = 0;
            wait(0.3);
            GREEN = 1;
            wait(0.3);
        }
        else if (state == '2') 
        {
            RED = GREEN = 1;
            BLUE = 0;
            wait(0.3);
            BLUE = 1;
            wait (0.3);
        }
        else if (state == '3') {
            RED = GREEN = 1;
            BLUE = 1;
            
        }
        
    }
}