#include "mbed.h"
#include "nRF24L01P.h"

#define V_SERVO_CENTER 1800
#define V_SERVO_MAX 2200
#define V_SERVO_MIN 800
#define H_SERVO_CENTER 1600
#define H_SERVO_MAX 2200
#define H_SERVO_MIN 800
#define TRANSFER_SIZE   9

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD6, PTD7, PTD5, PTD4, PTC12, PTC18);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

PwmOut v_servo(PTC2);
PwmOut h_servo(PTA2);

int main() {

    myled1 = 1;
    myled2 = 1;
    myled3 = 0;

    pc.baud(115200);
    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;

    my_nrf24l01p.setRxAddress(0xDEADBEEF0F);
    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "This is the Receiver\r\n");

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    
    v_servo.period_us(20000);          // servo requires a 20ms period
    v_servo.pulsewidth_us(V_SERVO_CENTER);
    h_servo.period_us(20000);          // servo requires a 20ms period
    h_servo.pulsewidth_us(H_SERVO_CENTER);
    
    int v_pulse = V_SERVO_CENTER;
    int h_pulse = H_SERVO_CENTER;

    v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
    h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms

    wait(0.5);
    
    int32_t acc_x, acc_y;
    
    while (1) {

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
            pc.printf("I just received data");
            
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            acc_x = (int32_t)((rxData[0])|(rxData[1]<<8)|(rxData[2]<<16)|(rxData[3]<<24));
            acc_y = (int32_t)((rxData[4])|(rxData[5]<<8)|(rxData[6]<<16)|(rxData[7]<<24));
           
            pc.printf("%d\t%d\t- \n\r",acc_x,acc_y);
            pc.printf("%01x %01x %01x %01x %01x %01x\n\r",rxData[1],rxData[0],rxData[3],rxData[2],rxData[5],rxData[4]);
            
            v_pulse = V_SERVO_CENTER + acc_x;
            h_pulse = H_SERVO_CENTER + acc_y;
    
            if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
            if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
    
            if (h_pulse <= H_SERVO_MIN) h_pulse = H_SERVO_MIN;
            if (h_pulse >= H_SERVO_MAX) h_pulse = H_SERVO_MAX;
    
            v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
            h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
            
            pc.printf("%d\t%d\t\n\r",v_pulse,h_pulse); 
        }
    }
}