#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "FXOS8700.h"
#include "FXAS21002.h"

#define LED_ON      0
#define LED_OFF     1
   
void StartHaptic(void);
void StopHaptic(void const *n);

Serial pc(USBTX, USBRX);
static int count=0;
bool ges_flag=false;

// Pin connections & address for Hexiwear
FXAS21002 gyro(PTC11, PTC10);
FXOS8700 accel(PTC11, PTC10);
FXOS8700 mag(PTC11, PTC10);
Timer t;

DigitalOut redLed(LED1);
DigitalOut greenLed(LED2);
DigitalOut blueLed(LED3);
DigitalOut haptic(PTB9);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

void ButtonUp(void)
{
    StartHaptic();
    count++;
    ges_flag=true;
    
    /*redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;*/
    
}

void ButtonDown(void)
{
    StartHaptic();
    
    redLed      = LED_OFF;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
}

void ButtonRight(void)
{
    StartHaptic();
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_ON;
}

void ButtonLeft(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
}

void ButtonSlide(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_ON;
}
   
int main()
{
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonUp(&ButtonUp);
    /*kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_buttonSlide(&ButtonSlide);*/
    
    accel.accel_config();
    mag.mag_config();
    gyro.gyro_config();

    float accel_data[3]; float accel_rms=0.0;
    float mag_data[3];   float mag_rms=0.0;
    float gyro_data[3]; 
    
    while (true) {
        if(ges_flag){
            
            while(count==1){
                 
                 ges_flag=false;
                 t.start();
    //while(1){
       
                   gyro.acquire_gyro_data_dps(gyro_data);
                  //accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),gyro_data[0],gyro_data[1],gyro_data[2]);
                  wait(0.01);
                  
                  accel.acquire_accel_data_g(accel_data);
                  //accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),accel_data[0],accel_data[1],accel_data[2]);
                  wait(0.01);
                  
                  mag.acquire_mag_data_uT(mag_data);
                  //mag_rms = sqrt(((mag_data[0]*mag_data[0])+(mag_data[1]*mag_data[1])+(mag_data[2]*mag_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),mag_data[0],mag_data[1],mag_data[2]);
                  wait(0.01);
                  printf("%d\n\r",1);
                  
                  Thread::wait(500);
                }
                
            if(count==2){
                    
                  ges_flag=false;
                  count=0;
                  gyro.acquire_gyro_data_dps(gyro_data);
                  //accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),gyro_data[0],gyro_data[1],gyro_data[2]);
                  wait(0.01);
                  
                  accel.acquire_accel_data_g(accel_data);
                  //accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),accel_data[0],accel_data[1],accel_data[2]);
                  wait(0.01);
                  
                  mag.acquire_mag_data_uT(mag_data);
                  //mag_rms = sqrt(((mag_data[0]*mag_data[0])+(mag_data[1]*mag_data[1])+(mag_data[2]*mag_data[2]))/3);
                  printf("%4.5f \t%4.5f \t%4.5f \t%4.5f \n\r",t.read(),mag_data[0],mag_data[1],mag_data[2]);
                  wait(0.01);
                  printf("%d\n\r",0);
                  Thread::wait(500);
                  
                  t.reset();
                    
                    }
            
            
            
            
            
            }
        Thread::wait(50);
    }
}

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}
