#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"
#include "time.h"
#include <sstream>


#define LED_ON      0
#define LED_OFF     1

void StartHaptic(void);
void StopHaptic(void const *n);
void resetBLE(void);
void displayTime(void);
void update_clock(void);

Serial pc(USBTX, USBRX);

DigitalOut redLed(LED1,1);
DigitalOut greenLed(LED2,1);
DigitalOut blueLed(LED3,1);
DigitalOut haptic(PTB9);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

/* Instantiate the SSD1351 OLED Driver */ 
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

/*Create a Thread to handle sending BLE Sensor Data */ 
//Thread txThread;
//Thread broadcastThread;
//Thread resetBLE_Thread;
Thread displayTime_Thread;
Thread update_clock_Thread;

/*Create a Timer to reset BLE */ 
Timer BLE_clock;
Timer t;

 /* Text Buffer */ 
char text[20]; 
char time_text[20];
char date_text[25];

uint8_t battery = 100;
uint8_t light = 0;
uint16_t humidity = 4500;
uint16_t temperature = 2000;
uint16_t pressure = 9000;
uint16_t x = 0;
uint16_t y = 5000;
uint16_t z = 10000;

float current_time;
char token1[15];
float alert_time = 0;
double float_time = 1528686283;
char buffer[16];
int new_reading = 0;
int BLE_status = 0;
char time_buffer[30];
char *smallbuff;
std::time_t timeinfo;
int LA_GMT = 25200;
int second_dec = 0;
int second_1d = 0;
int second_2d = 0;
int minute_1d = 0;
int minute_2d = 0;
int hour_1d = 0;
int hour_2d = 0;
char newtime_text[10];
char *token[10];
int int_time = float_time - LA_GMT;

/****************************Call Back Functions*******************************/


void ButtonRight(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();
}

void ButtonLeft(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();

}


void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,25,95,18);
  
    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,40,95,18);
}

// Key modification: use the alert functionality enabled by the host-ble interface
// to define our own command.
void AlertReceived(uint8_t *data, uint8_t length)
{
    redLed = !redLed;
    alert_time = BLE_clock.read();
    
    /*
    data[17] = 0;
    data[18] = 0;
    data[19] = 0;
    data[20] = 0;
    */
    // pc.printf("%s\r\n", data);
    // pc.printf("%i\r\n", data);
    
    sprintf(buffer, "%s", data);
    sscanf(buffer, "%lf", &float_time);
    // pc.printf("%s\r\n", Result);
    redLed = !redLed;
    
    int_time = float_time - LA_GMT;
    
    time_t timeinfo =(time_t) int_time;
    timeinfo=(time_t)int_time;
    sprintf(buffer,"%s",ctime(&timeinfo));
    
    token[0] = strtok(buffer, " ");
    
    // Keep printing tokens while one of the
    // delimiters present in str[].
    int i=0;
    while (token[i] != NULL) {
            // printf("[%d] %s\r\n", i, token[i]);
            i++;
            token[i] = strtok(NULL, " ");
        }


    
    new_reading = 1;
    
   
    
    /*
    if (data) {
        blueLed = LED_OFF;
        greenLed = LED_ON;
        wait_ms(1000);
        greenLed = LED_OFF;
        blueLed = LED_ON;
        }
    */
    
    /*
    // data (our command) must 20 bytes long.
    // CMD for turning on: 'ledonledonledonledon'
    if (data[4] == 'n') {
        greenLed = LED_ON;
        redLed = LED_ON;
        blueLed = LED_ON;
        pc.printf("on\n\r", data);
    
    // CMD for turning off: 'ledoffledoffledoffled'
    } else if (data[4] == 'f') {
        greenLed = LED_OFF;
        redLed = LED_OFF;
        blueLed = LED_OFF;
        pc.printf("off\n\r", data);
    }
    */
    
}
/***********************End of Call Back Functions*****************************/

/********************************Main******************************************/

int main()
{    
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_passkey(&PassKey);
    kw40z_device.attach_alert(&AlertReceived);
    
       
    //pc.printf("hello\n\r");
    
    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    
    /* Fills the screen with solid black */         
    oled.FillScreen(COLOR_BLACK);

    /* Get OLED Class Default Text Properties */
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    
        
    /* Change font color to Blue */ 
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);
    
    /* Display Bluetooth Label at x=17,y=65 */ 
    strcpy((char *) text,"BLUETOOTH");
    oled.Label((uint8_t *)text,17,65);
    
    /* Change font color to white */ 
    textProperties.fontColor   = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);
    
    /* Display Label at x=22,y=80 */ 
    strcpy((char *) text,"Tap Below");
    oled.Label((uint8_t *)text,22,80);

    // txThread.start(txTask); /*Start transmitting Sensor Tag Data */
    
    //resetBLE_Thread.start(resetBLE);
    
    // displayTime_Thread.start(displayTime);
    
    
    
    int counter = 0;
    int status = 0;
    
    BLE_clock.reset();
    BLE_clock.start();
    
    float start_time = BLE_clock.read();

    
        
    char date_text[20];
    char time_text[10];
    
    
    update_clock_Thread.start(update_clock);
    
    
    
    while (true) 
    {
        // counter += 1; 
        status = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/   
        blueLed = status;
  
        /*      
        if (status != BLE_status) {
            if (status == 1) {
                pc.printf("[%f] BLE is off.\r\n",BLE_clock.read());
                BLE_status = 1;
            }
            else {
                pc.printf("[%f] BLE is on.\r\n",BLE_clock.read(), status);
                BLE_status = 0;
           }
        }
        */
        
        if (new_reading == 1) {
            
            // pc.printf("New time: %lf\r\n", float_time);
            
            
            new_reading = 0;
            /*minute_2d = (int)time_text[3];
            minute_1d = (int)time_text[4];
            second_2d = (int)time_text[6];
            second_1d = (int)time_text[7];
            second_dec = 0;*/
            
            hour_2d=token[3][0]-'0';
            hour_1d=token[3][1]-'0';
            minute_2d=token[3][3]-'0';
            minute_1d=token[3][4]-'0';
            second_2d=token[3][6]-'0';
            second_1d=token[3][7]-'0';
            sprintf(newtime_text, "%d%d:%d%d:%d%d.%d", hour_2d, hour_1d, minute_2d, minute_1d, second_2d, second_1d, second_dec);
            // pc.printf("%s\r\n", token[3]);
            // sprintf(token1,"%s",token[3]);
            // pc.printf("%s\r\n", token1);
            /*
            for(int i=0;i<strlen(token1);i++)
            {
                pc.printf("%c\n",token1[i]);
                }
            */
            // pc.printf("Conversion successful: h2 h1 m2 m1 s2 s1 = %d %d %d %d %d %d\r\n", hour_2d, hour_1d, minute_2d, minute_1d, second_2d, second_1d);
            
        }
    
          //sprintf(newtime_text, "%d%d:%d%d:%d%d.%d", hour_2d, hour_1d, minute_2d, minute_1d, second_2d, second_1d, second_dec);
        
            // sprintf(date_text,"%s %s %s",token[1],token[2],token[4]);
            // strcpy(time_text,token[3]);

            oled.TextBox((uint8_t *)newtime_text,2,2, 91, 15); 
            // Label((uint8_t *)date_text,20,20);
            
    
        
    }
}

/******************************End of Main*************************************/

void StartHaptic(void)  {
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}

void resetBLE(void) {
        
    current_time = BLE_clock.read();
    
    if (current_time - alert_time > 60) {
        pc.printf("Haven't received new data in 60 seconds. Resetting BLE\r\n");
        kw40z_device.ToggleAdvertisementMode();
        Thread::wait(500);
        int status = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/
        
        while (status == 1) {
            StartHaptic();
            kw40z_device.ToggleAdvertisementMode();
            Thread::wait(5000);
        }
    }
        
    
}

void displayTime(void) {
    
    // Reminder to move the clock commands from main while(1) to here
    
}

void update_clock(void) {
    
    t.reset();
    t.start();
    
    while (1) {
    // Updating time
        
        
        if (t.read_ms() > 100) {
            second_dec++;
            t.reset();
            t.start();
        }
        
        if (second_dec>9) {
            second_1d++;
            second_dec = 0;
        }
        
        if (second_1d>9) {
            second_2d++;
            second_1d = 0;
            second_dec = 0;
        }
        
        if (second_2d*10 + second_1d > 59) {
            minute_1d++;
            second_2d = 0;
            second_1d = 0;
            second_dec = 0;
        }
        
        if (minute_1d>9) {
            minute_2d++;
            minute_1d = 0;
            second_2d = 0;
            second_1d = 0;
            second_dec = 0;
        }
        
        if (minute_2d*10 + minute_1d > 59) {
            hour_1d++;
            minute_2d = 0;
            minute_1d = 0;
            second_2d = 0;
            second_1d = 0;
            second_dec = 0;
        }
        
        if (hour_1d > 9) {
            hour_2d++;
            hour_1d = 0;
        }
        
        if (hour_2d == 2 && hour_1d > 3) {
            hour_2d = 0;
            hour_1d = 0;
            minute_2d = 0;
            minute_1d = 0;
            second_2d = 0;
            second_1d = 0;
            second_dec = 0;
        }
        
        
        
    }
    
    
}

