#ifndef MBED_WATCHDOG_TIMER_H
#define MBED_WATCHDOG_TIMER_H

/**
 * A class to encapsulate basic LPC1768 watchdog timer functionality.
 *
 * References:
 *  1) Chapter 28 in the LPC17xx UM.
 *  2) http://mbed.org/cookbook/WatchDog-Timer
 */
class WatchdogTimer
{

public:
    /**
     * WatchDogTimer no-arg constructor.
     */
    WatchdogTimer();
    
    /**
     * Enable and activate the watchdog with a given timeout value.
     *
     * Note! Once the watchdog has been enabled, there's no way to disable it.
     *
     * @param timeout watch time-out value (in seconds) 
     */    
    void enable(float timeout);
    
    /**
     * Feed the watchdog to reset the countdown timer.
     */    
    void feed();

    /**
     * Return whether the previous reset was caused by the watchdog timer.
     */ 
    static bool causedReset();
};

#endif