#include "mbed.h"
#include "WatchdogTimer.h"

WatchdogTimer::WatchdogTimer()
{
}

void WatchdogTimer::enable(float timeout)
{
    // Set the clock source (use peripheral clock)
    LPC_WDT->WDCLKSEL = 0x1;
    // Set the watchdog timer constant (watchdog prescaler is always 1/4, PCLK default is 1/4)
    LPC_WDT->WDTC = timeout * SystemCoreClock / (4.0 * 4.0);
    // Enable and reset (WDEN | WDRESET)
    LPC_WDT->WDMOD = 0x3;
    feed();
}

void WatchdogTimer::feed()
{
    // Feed sequence is 0xAA, 0x55.
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

bool WatchdogTimer::causedReset()
{
    // Read the watchdog time-out flag (WDTOF).
    return (LPC_WDT->WDMOD & 0x4);
}
