#include "speech.h"

#include "globals.h"
#include "hardware.h"

/**
 * Draw the speech bubble background.
 */
static void draw_speech_bubble();

/**
 * Erase the speech bubble.
 */
static void erase_speech_bubble();

/**
 * Draw a single line of the speech bubble.
 * @param line The text to display
 * @param which If TOP, the first line; if BOTTOM, the second line.
 */
#define TOP    0
#define BOTTOM 1
static void draw_speech_line(const char* line, int which);

/**
 * Delay until it is time to scroll.
 */
static void speech_bubble_wait();

void draw_speech_bubble()
{
    //draw speech bubble borders
    uLCD.line(0,   114, 127, 114, GREEN); // Bottom
    uLCD.line(0,   70, 127, 70, GREEN); // Top
    uLCD.line(0,   71, 0, 113, GREEN); // Left
    uLCD.line(127,   71, 127, 113, GREEN); // Right
    
    //fill speech bubble borders
    uLCD.filled_rectangle(1, 71, 126, 113, 5);
}

void erase_speech_bubble()
{
    //restore original color at speech bubble borders
    uLCD.line(0,   114, 127, 114, WHITE); // Bottom
    uLCD.line(0,   94, 127, 94, BLACK); // Top
    uLCD.line(0,   95, 0, 113, WHITE); // Left
    uLCD.line(127,   95, 127, 113, WHITE); // Right
    
    uLCD.filled_rectangle(1, 95, 126, 113, BLACK);
    
}

void draw_speech_line(const char* line, int which)
{
    if(which == TOP)
    {
        uLCD.locate(1,9);
        uLCD.printf(line);   
    }
    else if(which == BOTTOM)
    {
        uLCD.locate(1,10);
        uLCD.printf(line);      
    }
    else if(which == 3)
    {
        uLCD.locate(1,11);
        uLCD.printf(line);
    }
    else
    {
        uLCD.locate(1,12);
        uLCD.printf(line);
    }
    
}

void speech_bubble_wait()
{
    GameInputs inputs;
    inputs = read_inputs();
    int blink = 1;
    while(inputs.b1)
    {
        blink = !blink;
        wait_ms(200);
        if(blink)
            uLCD.filled_circle(123, 114, 3, GREEN);
        else
            uLCD.filled_circle(123, 114, 3, BLACK);
        inputs = read_inputs();
                
    }
}

void speech(const char* line1, const char* line2, const char* line3, const char* line4)
{
    draw_speech_bubble();
    draw_speech_line(line1, TOP);
    draw_speech_line(line2, BOTTOM);
    draw_speech_line(line3, 3);
    draw_speech_line(line4, 4);
    speech_bubble_wait();
    erase_speech_bubble();
}

void long_speech(const char* lines[], int n)
{
}
