#include "graphics.h"
#include "hardware.h"
#include "globals.h"


static int player[121] = {0x00000000, 0xff5a0c45, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff434345, 0xff434345, 0xff434345, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff434345, 0xff434345, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0xff3e2113, 0xff3e2113, 0xff277a28, 0xff277a28, 0xff3e2113, 0xff3e2113, 0xff277a28, 0xff277a28, 0xff3e2113, 0xff3e2113, 0x00000000, 
0x00ffe0bd, 0x00000000, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0x00000000, 0x00ffe0bd, 0x00000000, 
0x00000000, 0x00000000, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000
};

static int player_shield[121] = {0x00000000, 0xff5a0c45, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff434345, 0xff434345, 0xff434345, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff434345, 0xff434345, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0xff277a28, 0xff3e2113, 0xff3e2113, 0xff277a28, 0xff277a28, 0xff3e2113, 0xff3e2113, 0x00000000, 
0x00ff8d09, 0x00ff8d09, 0x00ff8d09, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0x00000000, 0xffbde0ff, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000};

static int player_sword[121] = {0x00000000, 0xff5a0c45, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff434345, 0xff434345, 0xff434345, 0xff3e2113, 0x00000000, 0x00ffd700, 0x00000000, 
0xff5a0c45, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff434345, 0xff434345, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00ffd700, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0xff277a28, 0xff3e2113, 0xff3e2113, 0xff277a28, 0xff277a28, 0x00ffd700, 0x00ffd700, 0x00ffd700, 
0x00ff8d09, 0x00ff8d09, 0x00ff8d09, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0x00000000, 0x00ffd700, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000};

static int player_plate[121] = {0x00000000, 0xff5a0c45, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0xff5a0c45, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff434345, 0xff434345, 0xff434345, 0xff3e2113, 0x00000000, 0x00ffd700, 0x00000000, 
0xff5a0c45, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 0x00ffd700, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff434345, 0xff434345, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00ffd700, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0x000ba1d9, 0xff3e2113, 0xff3e2113, 0x000ba1d9, 0x000ba1d9, 0x00ffd700, 0x00ffd700, 0x00ffd700, 
0x00ff8d09, 0x00ff8d09, 0x00ff8d09, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x00000000, 0x00ffd700, 0x00000000, 
0x00c66a00, 0x00ff8d09, 0x00c66a00, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x000ba1d9, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000};

static int player_running[121] = {0x00000000, 0x00000000, 0x00000000, 0xff5a0c45, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff5a0c45, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff434345, 0xff434345, 0xff434345, 0xff3e2113, 0x00000000, 
0x00000000, 0x00000000, 0xff5a0c45, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 
0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 
0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff434345, 0xff000000, 0xff3e2113, 
0xffb4b4b4, 0xffb4b4b4, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff434345, 0xff434345, 0xff3e2113, 0xff3e2113, 0x00000000, 
0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0xff277a28, 0xff277a28, 0xff3e2113, 0xff3e2113, 0xff277a28, 0xff3e2113, 0xff3e2113, 
0xffb4b4b4, 0xffb4b4b4, 0xffbde0ff, 0x00000000, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xffbde0ff, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0xff277a28, 0xff497a4a, 0x00000000, 
0xffb4b4b4, 0xffb4b4b4, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113, 0x00000000, 0x00000000, 0x00000000, 0xff3e2113, 0xff3e2113};

static int walls[121] = {0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 
0xff202020, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff202020, 
0xff202020, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff6d6d6e, 0xff202020, 
0xff202020, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff202020, 
0xff202020, 0xff6d6d6e, 0xff08320a, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff6d6d6e, 0xff08320a, 0xff202020, 
0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 
0xff202020, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff08320a, 0xff474747, 0xff474747, 0xff202020, 
0xff202020, 0xff474747, 0xff474747, 0xff474747, 0xff08320a, 0xff474747, 0xff08320a, 0xff474747, 0xff474747, 0xff474747, 0xff202020, 
0xff202020, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff08320a, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff202020, 
0xff202020, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff474747, 0xff08320a, 0xff474747, 0xff474747, 0xff474747, 0xff202020, 
0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020, 0xff202020};

static int plant[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff999999, 0xff999999, 0xff747474, 0xff747474, 0xff999999, 0xff999999, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff999999, 0xff999999, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff999999, 0xff999999, 0x00000000, 0x00000000, 
0x00000000, 0xff999999, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff999999, 0x00000000, 
0x00000000, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0x00000000};

static int startNPC[121] = {0x00000000, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00ff2525, 0x00000000, 0x00000000, 0x00000000, 
0x00ff2525, 0x00ff2525, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 
0xffffffff, 0x00000000, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00ffc58f, 0xffddd058, 0xffffffff, 0x00ffc58f, 0xffddd058, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00ffc58f, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xffff8fe1, 0x00ffc58f, 0x00d44b4b, 0x00d44b4b, 0x00ffc58f, 0xffff8fe1, 0x00000000, 0x00000000, 0x00000000, 
0xffff8fe1, 0xffff8fe1, 0xffff8fe1, 0xffff8fe1, 0x00ffc58f, 0x00ffc58f, 0xffff8fe1, 0xffff8fe1, 0xffff8fe1, 0xffff8fe1, 0x00000000, 
0x00ffc58f, 0x00000000, 0xffff8fe1, 0xffff6dd8, 0xffff8fe1, 0xffff8fe1, 0xffff6dd8, 0xffff8fe1, 0x00000000, 0x00ffc58f, 0x00000000, 
0x00000000, 0x00000000, 0xffff8fe1, 0xffff8fe1, 0xffff6dd8, 0xffff6dd8, 0xffff8fe1, 0xffff8fe1, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xffff8fe1, 0xffff8fe1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffff8fe1, 0xffff8fe1, 0x00000000, 0x00000000};

static int cave[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff838383, 0xff838383, 0xff838383, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0xff838383, 0xff252525, 0xff252525, 0xff252525, 0xff838383, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff838383, 0xff838383, 0xff252525, 0xff252525, 0xff252525, 0xff838383, 0xff838383, 0x00000000, 0x00000000, 
0x00000000, 0xff838383, 0xff838383, 0xff252525, 0xff252525, 0xff252525, 0xff252525, 0xff252525, 0xff838383, 0xff838383, 0x00000000, 
0x00000000, 0xff838383, 0xff323232, 0xff252525, 0xff252525, 0xff252525, 0xff252525, 0xff252525, 0xff323232, 0xff838383, 0x00000000, 
0xff838383, 0xff838383, 0xff323232, 0xff323232, 0xff323232, 0xff323232, 0xff323232, 0xff323232, 0xff323232, 0xff838383, 0xff838383, 
0xff838383, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff838383, 
0xff838383, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff585858, 0xff838383, 
0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383, 0xff838383};

static int swordInStone[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00ffd700, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00ffd700, 0x00ffd700, 0x00ffd700, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00ffd700, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00ffd700, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0xff999999, 0xff999999, 0x00ffd700, 0xff999999, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff999999, 0xff999999, 0xff747474, 0x00ffd700, 0xff999999, 0xff999999, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xff999999, 0xff999999, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff999999, 0xff999999, 0x00000000, 0x00000000, 
0x00000000, 0xff999999, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff747474, 0xff999999, 0x00000000, 
0x00000000, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0xff999999, 0x00000000};

static int elvarg[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00fff6f6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00808000, 0x00808000, 0x00000000, 0x00fff6f6, 0x00000000, 0x00000000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 
0x00808000, 0x00d20303, 0x00808000, 0x00fff6f6, 0x00000000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 
0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00000000, 
0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00000000, 0x00000000, 
0x00000000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 
0x00000000, 0x00000000, 0x00808000, 0x005a5a00, 0x00000000, 0x00000000, 0x005a5a00, 0x00808000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00fff6f6, 0x00808000, 0x005a5a00, 0x00000000, 0x00fff6f6, 0x005a5a00, 0x00808000, 0x00000000, 0x00000000, 0x00000000};

static int gate[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 
0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 
0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 
0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 0x00e5ea00, 
0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 0x00959826, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000};

static int treasure[121] = {0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 
0x004d3402, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x004d3402, 
0x004d3402, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x004d3402, 
0x004d3402, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x002d1e01, 0x004d3402, 
0x004d3402, 0x00d93b3b, 0x0050c878, 0x00ffd700, 0x00ffd700, 0x00ffd700, 0x00d93b3b, 0x00ffd700, 0x00ffd700, 0x0050c878, 0x004d3402, 
0x004d3402, 0x00ffd700, 0x00ffd700, 0x00d93b3b, 0x0050c878, 0x00ffd700, 0x00d93b3b, 0x00ffd700, 0x00d93b3b, 0x00ffd700, 0x004d3402, 
0x00d1d50b, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x00d1d50b, 
0x00d1d50b, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x00d1d50b, 
0x00d1d50b, 0x004d3402, 0x00d1d50b, 0x00d1d50b, 0x00d1d50b, 0x00d1d50b, 0x00d1d50b, 0x00d1d50b, 0x00d1d50b, 0x004d3402, 0x00d1d50b, 
0x00d1d50b, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x00d1d50b, 
0x00d1d50b, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x004d3402, 0x00d1d50b};

static int boulder[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0x00000000, 0x00000000, 
0x00000000, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0x00000000, 
0x00000000, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0x00000000, 
0x00000000, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0x00000000, 
0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0x00000000, 
0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 
0xff656565, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 
0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff656565, 0xff898989, 
0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 
0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff656565, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989, 0xff898989};

static int phat[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 
0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 0xffa3111a, 0x00000000, 
0x00000000, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0x00000000, 
0x00000000, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0x00000000, 
0x00000000, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0x00000000, 
0x00000000, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0xffa3111a, 0x00000000};

static int rolling[121] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffc5c5c5, 0xffc5c5c5, 0xffc5c5c5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000};

void draw_player(int u, int v, int key)
{
    if(key == 0)
        uLCD.BLIT(u, v, 11, 11, player);
    else if(key == 1)
        uLCD.BLIT(u, v, 11, 11, player_shield);
    else if(key == 2)
        uLCD.BLIT(u, v, 11, 11, player_sword);
    else if(key == 3)
        uLCD.BLIT(u, v, 11, 11, player_plate);
    else if(key == 4)
        uLCD.BLIT(u, v, 11, 11, player_running);
}

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN
void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else if (img[i] == '5') colors[i] = LGREY;
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_nothing(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_wall(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, walls);
}

void draw_plant(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, plant);
}

void draw_startNPC(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, startNPC);    
}

void draw_cave(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, cave);   
}

void draw_swordInStone(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, swordInStone);   
}

void draw_elvarg(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, elvarg);   
}

void draw_gate(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, gate);   
}

void draw_treasure(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, treasure);
}

void draw_boulder(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, boulder);    
}

void draw_phat(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, phat);
}

void draw_rolling(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, rolling);    
}

void draw_upper_status(int x_pos, int y_pos)
{
    // Draw bottom border of status bar
    uLCD.line(0, 9, 127, 9, GREEN);
    // Add other status info drawing code here
    uLCD.locate(0,0);
    uLCD.printf("X:%-3iY:%-2i", x_pos, y_pos);
}


void draw_lower_status(int health, int phats)
{
    // Draw top border of status bar
    uLCD.line(0, 118, 127, 118, GREEN);
    // Add other status info drawing code here
    uLCD.locate(0,15);
    uLCD.printf("HP:%-3iPHats:%-2i/5", health, phats);
}

void draw_menu(int omnipotent, int sword, int shield, int platebody, int key)
{
    uLCD.filled_rectangle(0, 10, 127, 117, 0xD3D3D3);
    uLCD.textbackground_color(0xD3D3D3);
    uLCD.color(0x000000);
    uLCD.locate(0,2);
    uLCD.printf("Menu: Exit w/ B3\n");
    uLCD.printf("----------------\n");
    uLCD.printf("Omnipotent:%i\n", omnipotent);
    if(shield)
        uLCD.printf("Goal:Defeat Elvarg");
    else if(platebody)
        uLCD.printf("Goal:Return to NPC");
    uLCD.printf("Shield:    %i\n", shield);
    if(shield == 0)
        uLCD.printf("  Talk to NPC\n");
    uLCD.printf("Sword:     %i\n", sword);
    if(sword == 0)
        uLCD.printf("  Find Excalibur\n");
    uLCD.printf("Key:       %i\n", key);
        if(key == 0)
            uLCD.printf("  Defeat Elvarg\n");
    uLCD.printf("Platebody: %i\n", platebody);
        if(platebody == 0)
            uLCD.printf("  Unlock Treasure\n");
    uLCD.textbackground_color(0x000000);
    uLCD.color(GREEN);
    GameInputs inputs = read_inputs();
    while(inputs.b3)
    {
        wait_ms(200);
        inputs = read_inputs();
    }
} 

void draw_border()
{
    uLCD.filled_rectangle(0,     9, 127,  14, WHITE); // Top
    uLCD.filled_rectangle(0,    13,   2, 114, WHITE); // Left
    uLCD.filled_rectangle(0,   114, 127, 117, WHITE); // Bottom
    uLCD.filled_rectangle(124,  14, 127, 117, WHITE); // Right
}

void draw_bad()
{
    uLCD.filled_rectangle(0, 0, 127, 127, 0xBB0A1E);
    uLCD.textbackground_color(0xBB0A1E);
    uLCD.color(0xFFFFFF);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.locate(0,2);
    uLCD.printf("YOU DIED!");
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.locate(2,10);
    uLCD.printf("Reset Mbed");
}

void draw_good()
{
    uLCD.filled_rectangle(0, 0, 127, 127, 0x40E0D0);
    uLCD.textbackground_color(0x40E0D0);
    uLCD.color(0xFFFFFF);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.locate(0,2);
    uLCD.printf("Quest\nCompleted\n!!!!!!!!!!!");
}

void draw_start()
{
    uLCD.filled_rectangle(0, 0, 127, 127, 0x808000);
    uLCD.textbackground_color(0x808000);
    uLCD.color(0xBB0A1E);
    uLCD.text_width(3);
    uLCD.text_height(3);
    uLCD.locate(0,0);
    uLCD.printf("Dragon\nSlayer");
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.locate(1,14);
    uLCD.printf("Press any button");
    uLCD.textbackground_color(0x000000);
    uLCD.color(GREEN);
    GameInputs inputs = read_inputs();
    while(inputs.b1 && inputs.b2 && inputs.b3)
    {
        wait_ms(200);
        inputs = read_inputs();
    }
}

