// Sweep the motor speed from full-speed reverse (-1.0) to full speed forwards (1.0)
 
#include "mbed.h"
#include "Motor.h"
#include "TextLCD.h"

Motor m(p21, p23, p28); // pwm, fwd, rev
DigitalOut led(LED1);
DigitalOut test(LED2);
TextLCD lcd(p14, p16, p17, p18, p19, p20, TextLCD::LCD20x4); // rs, e, d4-d7
DigitalOut high(p22);
DigitalIn pb(p6);
DigitalOut high2(p29); 
AnalogIn slider(p15);
Serial pc(USBTX, USBRX);
void open();
void close();
void printTime(double);
int state;
char buffer[32];
time_t seconds;
double setTime;
struct tm* timeInfo;

int main() {
    set_time(    702000900    );  
    state = 1; //Start with blinds closed (0 is open)
    pb.mode(PullUp);
    int lastPb = pb;
    lcd.cls();
    wait(1);
    while (1){
        seconds = time(NULL);
        if (abs(slider.read()-setTime)>.006){ // <-- this is the line of percision
            setTime = slider.read();
        }
        printTime(setTime);
        
        pc.printf("%f \n", slider.read());
        high = 1; //seems unused
        high2 = 1; //seems unused
        if (!pb){  
            if (state == 1){
                open();
                led = 1;
                pc.printf("open");
            }
            else {
                close();
                led = 0;
                pc.printf("close");
            }
        }
        m.speed(0);
        wait(.2);
    }
}

void open() {
    m.speed(-1);
    test = 1; // for testing purposes, the system should be running
    wait(2.6);
    test = 0;
    state = 0;
}

void close() {
    m.speed(1);
    wait(2.6);
    state = 1;
}

// Takes analog input from 0 to 1 and displays a time based on that
void printTime(double in) {
    int totMins = in*1440; //maps to integer based on mins in a day
    int hrs = totMins/60;
    int mins = totMins%60;
    timeInfo = localtime(&seconds);
    lcd.locate(0,0);
    lcd.printf("time: %2.2d:%2.2d",timeInfo->tm_hour,timeInfo->tm_min); // added percision to make it more like a clock HH:MM
    lcd.locate(0,1);
    lcd.printf("start: %2.2d:%2.2d",hrs,mins);
    if ((state == 1) && (hrs == timeInfo->tm_hour) && (mins == timeInfo->tm_min)){
        open();
    }
}