#include "ble/BLE.h"
#include "mbed.h"

BLE           ble;
Timeout       timeout;

#define TXRX_BUF_LEN                      20
Serial pc(USBTX, USBRX);

//**********TAG Personalization***********************
//****************************************************
char TAG_ADDRESS[]="D2:FB:BE:68:EF:5A"; 
//char TAG_ADDRESS[]="EE:04:D4:1A:9C:16";
//char TAG_ADDRESS[]="F6:99:64:A9:FD:6D";
//char TAG_ADDRESS[]="D6:F7:8B:78:5D:BD";
//char TAG_ADDRESS[]="D7:8F:65:5C:A0:B9";
int password=135;
//****************************************************



int stealthModeActive=0;
uint8_t chars_value[TXRX_BUF_LEN] = {0,};

// The Nordic UART Service
static const uint8_t cityRiskServiceUuid[]                = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t cityRiskCharacteristcUuid[]         = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[]           = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};


GattCharacteristic  cityRiskCharacteristic(cityRiskCharacteristcUuid, chars_value, 3, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);

GattCharacteristic *cityRiskChars[] = {&cityRiskCharacteristic};

GattService         cityRiskService(cityRiskServiceUuid, cityRiskChars, sizeof(cityRiskChars) / sizeof(GattCharacteristic *));


//static void scanCallBack(const Gap::AdvertisementCallbackParams_t *params);

/*************************************************************************************
*Function Name: autodisconnect
**************************************************************************************
*  Summary: Function is called to disconnect automatically
*   
*
*   Parameters:
*     None
*
*   Return:
*     None
*
************************************************************************************/
void autodisconnect(){
 
 if (ble.getGapState().connected){
  ble.gap().disconnect(Gap::LOCAL_HOST_TERMINATED_CONNECTION);
 // pc.printf("Autodisconnect\n");
 }  
}
/*************************************************************************************
*Function Name: beaconInit
**************************************************************************************
*  Summary: Setup peripheral profile
*   
*
*   Parameters:
*     None
*
*   Return:
*     None
*
************************************************************************************/
void beaconInit (void){  
  ble.gap().startAdvertising();
//  pc.printf("beacon Init\n");
}

/*************************************************************************************
*Function Name: ble_advdata_decode
**************************************************************************************
*  Summary: Used by the scan call back function to declare a successful scan.
*   
*
*   Parameters:
*     BLE_GAP_AD_TYPE_SHORT_LOCAL_NAME, params->advertisingDataLen, 
*     (uint8_t *)params->advertisingData, &len, adv_name : Parameters the adverising device sends
*     and the scan retrieves
*
*   Return:
*     NRF Succes or not
*
************************************************************************************/
int ble_advdata_decode(uint8_t type, uint8_t advdata_len, uint8_t *p_advdata, uint8_t *len, uint8_t *p_field_data){
    
    uint8_t index=0;
    uint8_t field_length, field_type;
    
    while(index<advdata_len){
        field_length = p_advdata[index];
        field_type   = p_advdata[index+1];
        if(field_type == type){
            memcpy(p_field_data, &p_advdata[index+2], (field_length-1));
            *len = field_length - 1;
            return 1;
        }
        index += field_length + 1;
    }
    return 0;
}
/*************************************************************************************
*Function Name: scanCallBack
**************************************************************************************
*  Summary: Start scan for a device. When a spesific device defined by a certain name 
*  is scanned, the device changes from Central to Peripheral.
*   
*
*   Parameters:
*     Gap::AdvertisementCallbackParams_t *params: The Params returned by the scan. The
*     Params are the ones the peripheral device advertises.
*
*   Return:
*     None
*
************************************************************************************/
static void scanCallBack(const Gap::AdvertisementCallbackParams_t *params){
  
  uint8_t len;
  uint8_t adv_name[31];
 // pc.printf("packetscanned\n");
  if( 1 == ble_advdata_decode(0x09, params->advertisingDataLen, (uint8_t *)params->advertisingData, &len, adv_name) ){
 //   pc.printf("stage1\n");
    //pc.printf("%x",&adv_name,"\n");
    if (memcmp(TAG_ADDRESS, adv_name, len) == 0x00){
      ble.stopScan();
      stealthModeActive=0;
      beaconInit();
  //    pc.printf("activation\n");
    }
  }
}
/*************************************************************************************
*Function Name: stealthModeInit
**************************************************************************************
*  Summary: Initiate central profile
*   
*
*   Parameters:
*     None
*
*   Return:
*     None
*
************************************************************************************/
void stealthModeInit(void){
  ble.gap().startScan(scanCallBack);
  pc.printf("stealthmode\n");
}



/**************************************************************************************
*Function Name: writtenHandle                                                         *
***************************************************************************************
*  Summary: GATT call back handle. When a write service is offered by the device this *
*  function handles the data the client sends.                                        *
*                                                                                     *
*                                                                                     *
*   Parameters:                                                                       *
*     GattWriteCallbackParams *Handler: The Params returned by a write action of the  *
*     client.                                                                         *
*                                                                                     *
*   Return:                                                                           *
*     None                                                                            *
*                                                                                     *
**************************************************************************************/
void gattServerWriteCallBack(const GattWriteCallbackParams *Handler) {
  uint8_t index;
  uint8_t buf[TXRX_BUF_LEN];
  uint16_t bytesRead;
  int code;
  /*if (Handler->handle == cityRiskCharacteristic.getValueAttribute().getHandle()){
    
   }*/
   pc.printf("writecallback\n");
   ble.readCharacteristicValue(cityRiskCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
    /*for( index=0; index<bytesRead; index++){
      code=buf[index];
      pc.printf(code,"\n");
    }*/
    code=Handler->data[0];
 //   pc.printf("%d",code,"\n");
    
    if (code==password){
      stealthModeActive=1;
 //     pc.printf("Success\n");
    }       
  
  //ble.disconnect(Gap::LOCAL_HOST_TERMINATED_CONNECTION);  
}

/*************************************************************************************
*Function Name: disconnectionCallBack
**************************************************************************************
*  Summary: Function is called when our device disconnects from another device
*   
*
*   Parameters:
*     Gap::Handle_t handle, Gap::DisconnectionReason_t reason
*
*   Return:
*     None
*
************************************************************************************/
void disconnectionCallBack(const Gap::DisconnectionCallbackParams_t *params)
{
//  pc.printf("disconnect\n");
  if (stealthModeActive==0){
    beaconInit();
  }
  else{
    stealthModeInit();
  }
}

/*************************************************************************************
*Function Name: ConnectionCallBack
**************************************************************************************
*  Summary: Function is called when our device connects to another device
*   
*
*   Parameters:
*     Gap::ConnectionCallbackParams_t
*
*   Return:
*     None
*
************************************************************************************/
void connectionCallBack( const Gap::ConnectionCallbackParams_t *params ){
//  pc.printf("Connected\n");
  timeout.attach(autodisconnect, 3);
  //disconnection time out after 3 sec central device is get disconnected!
}
/*************************************************************************************
*Function Name: setup
**************************************************************************************
*  Summary: Basic setup for the SoC. Setup for central/peripheral roles
*   
*
*   Parameters:
*     None
*
*   Return:
*     None
*
************************************************************************************/
int main(void)
{
  ble.init();
  ble.onConnection(connectionCallBack);
  ble.onDisconnection(disconnectionCallBack);
  ble.onDataWritten(gattServerWriteCallBack);  
  ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
  ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,
                                     (const uint8_t *)"Beacon02", sizeof("Beacon02") - 1);
//change here complete local name                                     
 // ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,(const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid_rev));                                   
 // to check the operation commenting uart_base_uuid_rev
          // set adv_type 
  //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::DEVICE_ID);        
  ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
            // add service
  ble.addService(cityRiskService);
  ble.gap().setDeviceName((const uint8_t *)"Beacon02");
            // set tx power,valid values are -40, -20, -16, -12, -8, -4, 0, 4
  ble.gap().setTxPower(0);
            // set adv_interval, in ms
  ble.gap().setAdvertisingInterval(100);
            // set adv_timeout, in seconds
  ble.gap().setAdvertisingTimeout(0);
  ble.gap().setScanParams(1000,100,0,false);
  beaconInit();
  pc.printf("start\n");
  while (1){
      ble.waitForEvent();
    }  
}