#include "mbed.h"

// Labs 2:  polling and rate change by button

DigitalIn b1(PTD0, PullUp);
DigitalOut led(LED1);

double rate = 100;

Thread pollT ; // thread to poll
volatile int pressEvent = 0 ;  // Variabe set by the polling thread

enum buttonPos { up, down, bounce }; // Button positions
void polling() {
    buttonPos pos = up ;
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ;
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    led = 1 ;  // Initially off
    int cycle = 1; // cycle of 100 waiting
    int changeCycle = 2;
    pollT.start(callback(polling));

    while(true) {
        if (pressEvent) {
            pressEvent = 0 ; // clear the event variable

            switch (changeCycle) {
                case 2 :
                    changeCycle = 4 ;
                    break ;
                case 4 :
                    changeCycle = 6 ;
                    break ;
                case 6 :
                    changeCycle = 8 ;
                    break ;
                case 8 :
                    changeCycle = 10 ;
                    break ;
                case 10 :
                    changeCycle = 2 ;
                    break ;
            }
            cycle = 1;      
        }
        

        if(cycle == changeCycle) {
           if(led == 1) {
                led = 0;
            } else if (led == 0) {
                led = 1;   
            }
           
           cycle = 1; // reset the cycle
        } else {            
            cycle = cycle + 1; // go to the next cycle
        }
        
        Thread::wait(100) ;
    }
}