#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button_blue(PTD0);
DigitalOut led_blue(LED_BLUE);

InterruptIn button_red(PTD4);
DigitalOut led_red(LED_RED);

volatile int pressEvent_blue = 0;
volatile int pressEvent_red = 0;


// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur
void buttonCallback_blue()
{
    pressEvent_blue = 1 ;
}
void buttonCallback_red()
{
    pressEvent_red = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main()
{
    led_blue = 0;
    led_red = 0;
    
    button_blue.mode(PullUp);             // Ensure button i/p has pull up
    button_blue.fall(&buttonCallback_blue) ;   // Attach function to falling edge

    button_red.mode(PullUp);
    button_red.fall(&buttonCallback_red);

    // active mode of each LED
    int active_blue = 1;
    int active_red = 1;

    // cycle counter of each LED
    int cycle_blue = 1;
    int cycle_red = 1;

    while(true) {
        // blue led
        if (pressEvent_blue) {
            active_blue = !active_blue;
            pressEvent_blue = 0 ; // Clear the event variable
            cycle_blue = 1;
        }
        if(active_blue) {
            if(cycle_blue == 5) {
                led_blue = !led_blue ;
                cycle_blue = 1;
            } else {
                cycle_blue = cycle_blue+1;
            }
        }

        // red led
        if (pressEvent_red) {
            active_red = !active_red;
            pressEvent_red = 0 ; // Clear the event variable
            cycle_red = 1;
        }
        if(active_red) {
            if(cycle_red == 5) {
                led_red = !led_red ;
                cycle_red = 1;
            } else {
                cycle_red = cycle_red+1;
            }
        }

        Thread::wait(100) ;
    }
}