#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
DigitalOut whiteLED(PTC9);     // External LED

TSISensor tsi;

Thread leftOutThread (osPriorityNormal, 1000);
Thread leftInThread (osPriorityNormal, 1000);
Thread rightInThread (osPriorityNormal, 1000);
Thread rightOutThread (osPriorityNormal, 1000);

enum states { LeftOut, LeftIn, RightIn, RightOut, None};
volatile states state = None;



//void green_thread() {  // method to run in thread
//    while (true) {
//        Thread::signal_wait(0x1);
//        greenLED = !greenLED ; // turn on
//      
//        greenThread.signal_clr(0x1) ;
//          // Signal are automatically cleared by wait_signal but
//          // the signal might have been set again while LED on
//    }
//}

//void TurnOnLed(int ledNumber)
//{
//    switch (ledNumber) {
//        case 1:
//            redLED = false;
//            greenLED = true;
//            blueLED = true;
//
//            whiteLED = 0;
//            break;
//
//        case 2:
//            redLED = true;
//            greenLED = false;
//            blueLED = true;
//
//            whiteLED = 0;
//            break;
//
//        case 3:
//            redLED = true;
//            greenLED = true;
//            blueLED = false;
//
//            whiteLED = 0;
//            break;
//
//        case 4:
//            redLED = true;
//            greenLED = true;
//            blueLED = true;
//
//            whiteLED = 1;
//            break;
//    }
//}

void TurnOffLed()
{
    redLED = true;
    greenLED = true;
    blueLED = true;
    whiteLED = 0;

}


void leftOut_thread()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1); // signal for enter
        redLED = false;

        Thread::signal_wait(0x1); // signal for exit
        redLED = true;

        leftOutThread.signal_clr(0x1);
        leftOutThread.signal_clr(0x2);
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again
    }
}

void leftIn_thread()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1); // signal for enter
        greenLED = false;

        Thread::signal_wait(0x1); // signal for exit
        greenLED = true;

        leftInThread.signal_clr(0x1);
        leftInThread.signal_clr(0x2);
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again
    }
}


void rightIn_thread()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1); // signal for enter
        blueLED = !blueLED;

        Thread::signal_wait(0x1); // signal for exit
        blueLED = !blueLED;

        rightInThread.signal_clr(0x1);
        rightInThread.signal_clr(0x2);
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again
    }
}


void rightOut_thread()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1); // signal for enter
        whiteLED = 1;

        Thread::signal_wait(0x1); // signal for exit
        whiteLED = 0;

        rightOutThread.signal_clr(0x1);
        rightOutThread.signal_clr(0x2);
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again
    }
}




int main(void)
{
    TurnOffLed(); // initial turning off LED

    leftOutThread.start(&leftOut_thread) ; // start the leftOut thread
    leftInThread.start(&leftIn_thread) ; // start the leftIn thread
    rightInThread.start(&rightIn_thread) ; // start the rightIn thread
    rightOutThread.start(&rightOut_thread) ; // start the rightOut thread

    while (true) {
        uint8_t pos = tsi.readDistance() ;  // Distance is between 0 and 39

        pc.printf("%d", pos) ;
        pc.putc(' ') ;

//        // start states
//        if (pos>3 && pos<9) {
//            leftOutThread.signal_set(0x1);
//        } else if(pos>13 && pos<19) {
//            leftInThread.signal_set(0x1);
//        } else if(pos>23 && pos<29) {
//            rightInThread.signal_set(0x1);
//        } else if(pos>33) {
//            rightOutThread.signal_set(0x1);
//        }

        switch (state) {
            case LeftOut:
                if(pos<3 || pos>9) {
                    state = None ;
                }
                break;

            case LeftIn:
                if(pos<13 || pos>19) {
                    state = None ;
                }
                break;

            case RightIn:
                if(pos<23 || pos>29) {
                    state = None ;
                }

                break;

            case RightOut:
                if(pos<33) {
                    state = None ;
                }
                break;

            case None:
                if(pos>3 && pos<9) {
                    state = LeftOut;
                    leftOutThread.signal_set(0x1);
                } 
                if(pos>13 && pos<19) {
                    state = LeftIn;
                    leftInThread.signal_set(0x1);
                } 
                if(pos>23 && pos<29) {
                    state = RightIn;
                    rightInThread.signal_set(0x1);
                } 
                if(pos>33) {
                    state = RightOut;
                    rightOutThread.signal_set(0x1);
                } 
                
                break;

        }


        Thread::wait(100);  // This polling rate is too slow - increase it
        // The slower rate maks it easier to output on the terminal
    }
}