#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    
    enum states { FLAT, RIGHT, LEFT, DOWN, UP, OVER, INTERMEDIATE };
    states state = INTERMEDIATE;
    states pastState = INTERMEDIATE;
    states lastStableState = INTERMEDIATE;
    int stateCounter = 0;
    int const stableState = 3;

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z, ts;
 
        //threshold
        ts = 0.15;

        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        if (z > 1-ts && z < 1+ts) {
            state = FLAT;
        } else if (z > -1-ts && z < -1+ts) {
            state = OVER;
        } else if (y > -1-ts && y < -1+ts) {
            state = RIGHT;
        } else if (y > 1-ts && y < 1+ts) {
            state = LEFT;
        }  else if (x > -1-ts && x < -1+ts) {
            state = UP;
        } else if (x > 1-ts && x < 1+ts) {
            state = DOWN;
        }  else {
            state = INTERMEDIATE;
        }
        
        if (state != INTERMEDIATE) {
            if (state == pastState) {
                if (stateCounter < stableState) {
                    stateCounter ++;
                }
            } else {
                pastState = state;
                stateCounter = 0;
            }
        } else {
           // special colour for intermediate level
           rled = 0.9;
           gled = 0.9;
           bled = 0.9;
        }
        
        // print the state
        if (stateCounter == stableState && lastStableState != state) {
            lastStableState = state;
            switch (state) {
                case FLAT:
                    pc.printf("Flat state \n\r");
                    
                    rled = 0.0;
                    gled = 0.0;
                    bled = 1.0;
                    break;
                
                case LEFT:
                    pc.printf("Left state \n\r");
                    
                    rled = 1.0;
                    gled = 1.0;
                    bled = 0.0;
                    break;
                
                case RIGHT:
                    pc.printf("Right state \n\r");
                    
                    rled = 1.0;
                    gled = 0.0;
                    bled = 0.0;                    
                    break;
                
                case UP:
                    pc.printf("Up state \n\r");
                    
                    rled = 0.0;
                    gled = 1.0;
                    bled = 1.0;
                    break;
                    
                case DOWN:
                    pc.printf("Down state \n\r");
                    
                    rled = 0.0;
                    gled = 1.0;
                    bled = 0.0;
                    break;
                
               
               case OVER:
                    pc.printf("over \n\r");
                    
                    rled = 1.0;
                    gled = 0.0;
                    bled = 1.0;
                    break;
            }
        }
        
        
        Thread::wait(300);
    }
}
