#include "mbed.h"
//#include "SWO.h"

InterruptIn btn(PA_8);
DigitalOut rLed(PB_8);
DigitalOut NRST_OUT(PA_11);

Serial ser2Lora(PA_9, PA_10);
Serial ser2PC(PB_10, PB_11);

Ticker t1;

void timerCallback(void);
void btnCallback(void);

int main()
{
    t1.attach(&timerCallback, 0.2);
    btn.rise(&btnCallback);
    NRST_OUT = 1;
    while(1) {
        if(ser2Lora.readable()) {
            ser2PC.putc(ser2Lora.getc());
        }
        if(ser2PC.readable()) {
            ser2Lora.putc(ser2PC.getc());
        }
        wait(0.2);
    }
}

void timerCallback()
{
    rLed = !rLed;
}

void btnCallback()
{
    NRST_OUT = 0;
    wait(0.1);
    NRST_OUT = 1;
    
}