#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
#include <sstream>
#define READALL_OFF 1
#define SETTIME_OFF 2
#define SETT_OFF    4
#define READ_OFF    7
#define ALL_OFF     9



DigitalOut myled(LED1);
I2C i2c2(I2C_SDA, I2C_SCL);
Serial pc(USBTX, USBRX);
float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100;
char buffer_str=0;
uint32_t seconds = 0, minutes=0, hours=0;
Ticker t;
volatile static unsigned short sample16 = 0;
void doSample1Hz();
int count = 0;
char *buf;
size_t sz;
typedef struct {
    float temp;
    float press;
    float humid;
} measurement;
measurement buffer [120];

LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);

void function1();


Thread t1;
Thread tSample;

osThreadId idMain;
osThreadId id1;
osThreadId id2;
osThreadId id3;
osThreadId id4;

Ticker ticker;

void function1()
{//begin function
    while (true) {//begin while true
        char buffer [128];
        scanf("%127s", buffer);
        string buffer_str(buffer);
        char date [32];
        strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
        char time [32];
        strftime(time, 32, "%H:%M:%S %p", localtime(&seconds));

        if(buffer_str=="READALL") {//begin if buffer readall
            humidity.ReadTempHumi(&tempCelsius, &humi); // reads temperature and humity levels
            barometer.get(); // gets barometer readings
            // displays all the variables of time, date, temperature, humidity and all the barometric readings to the serial
            printf("%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, barometer.pressure(), barometer.temperature());
            myled = 1; // LED is ON
            Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds!
            myled = 0; // LED is OFF
            t1.signal_set(READALL_OFF);
        }//end if buffer readall
        Thread::wait(200);

        //Thread::signal_wait(READALL_OFF);
        
        if(buffer_str=="SETTIME") {// begin if buffer settime
            set_time(1508268288);
            printf("time and date updated to %s %s\n\r", time, date);
            myled = 1;
            Thread::wait(200);
            myled = 0;
            t1.signal_set(SETTIME_OFF);
        }//end if buffer settime
        Thread::wait(200);


        //Thread::signal_wait(SETTIME_OFF);
        
        if(buffer_str=="SETT") // begin if buffer sett
        {
            for (count = 0; count < 5; count++) {
                float temp = barometer.temperature();
                float pressure = barometer.pressure();
                
                sz = snprintf(NULL, 0,"%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, pressure, temp);
                buf = (char *)malloc(sz + 1);
                snprintf(buf, sz + 1, "%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, pressure, temp);
                printf("%s\n\r",buf);
                free(buf);
                printf("written to memory\n\r");
                myled = 1;
                Thread::wait(200);
                myled = 0;
                t1.signal_set(SETT_OFF);
            } //end if buffer sett
            Thread::wait(200);
         }   
        

        //Thread::signal_wait(SETT_OFF);

        if(buffer_str=="READ") { //begin if buffer read
            printf("%s\n\r", buf);
            myled = 1;
            Thread::wait(200);
            myled = 0;
            osSignalSet(idMain, ALL_OFF);
        }//end if buffer read
        Thread::wait(200);
    }//end while true
}//end function

    void getSampleThread() {
        while (true) {
            Thread::signal_wait(99);
           //Get samples   
           
           //Put in buffer 
        }
    }

    void getSample() {
        tSample.signal_set(99);      
    }

    int main() 
    {
        pc.baud(9600); //sets baud rate to 9600
        ticker.attach(getSample, 15);
        tSample.start(getSampleThread);
        
        time_t seconds = time(NULL);
        idMain = osThreadGetId();
        t1.start(function1);
        id1 = t1.gettid();
        humidity.init();
        humidity.calib();
        printf("Type SETTIME to set time and date [enter] \n\r");
        printf("Type SETT to start sampling [ENTER]\n\r");
        printf("Type DELETEALL to delete sensor data [enter]\n\r");
        printf("Type READALL [enter]\n\r");
        printf("Type READ to read sensor data in memory [ENTER]\n\r");


        while(1) {
            char buffer [128];
            scanf("%127s", buffer);
            string buffer_str(buffer);
            osSignalWait(ALL_OFF,osWaitForever);

        }
}

