#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
#include <sstream>
#define READALL_OFF 1
#define SETTIME_OFF 2
#define SETT_OFF    4
#define READ_OFF    7   
#define ALL_OFF     9  



DigitalOut myled(LED1);
I2C i2c2(I2C_SDA, I2C_SCL);
Serial pc(USBTX, USBRX);
float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100;
char buffer_str=0;
uint32_t seconds = 0, minutes=0, hours=0;
Ticker t;
volatile static unsigned short sample16 = 0;
void doSample1Hz();
int count = 0;
char *buf;
size_t sz;
typedef struct {
    float temp;
    float press;
    float humid;
} measurement;
measurement buffer [120];

LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);

void function1();
void function2();
void function3();
void function4();

Thread t1;
Thread t2;
Thread t3;
Thread t4;
Thread t5;

osThreadId idMain;
osThreadId id1;
osThreadId id2;
osThreadId id3;
osThreadId id4;

   

void function1()
{
    while (true){
    char buffer [128];
    scanf("%127s", buffer);
    string buffer_str(buffer);
    char date [32];
    strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
    
    if(buffer_str=="READALL") {
        humidity.ReadTempHumi(&tempCelsius, &humi); // reads temperature and humity levels
        barometer.get(); // gets barometer readings
        // displays all the variables of time, date, temperature, humidity and all the barometric readings to the serial
        printf("%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, barometer.pressure(), barometer.temperature());
        myled = 1; // LED is ON
        t2.signal_set(READALL_OFF);
        }
        Thread::wait(200);
        //Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds!
        //myled = 0; // LED is OFF
        //Thread::wait(100); // 100 ms
        }
}
void function2()
{
    while (true){
    Thread::signal_wait(READALL_OFF);    
    char buffer [128];
    scanf("%127s", buffer);
    string buffer_str(buffer);
    char date [32];
    strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
    if(buffer_str=="SETTIME") {
        set_time(1508268288);
        printf("time and date updated to %s %s\n\r", time, date);
        myled = 1;
        
        t3.signal_set(SETTIME_OFF);
        }
        //Thread::wait(200);
        //Thread::wait(200);
        //myled = 0;
        //Thread::wait(100);
        }
}

void function3()
{
    while (true){
    Thread::signal_wait(SETTIME_OFF);    
    char buffer [128];
    scanf("%127s", buffer);
    string buffer_str(buffer);
    char date [32];
    strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
    if(buffer_str=="SETT") {
        for (count = 0; count < 5; count++) {
            sz = snprintf(NULL, 0,"%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, barometer.pressure(), barometer.temperature());
            buf = (char *)malloc(sz + 1);
            snprintf(buf, sz + 1, "%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, barometer.pressure(), barometer.temperature());
            printf("%s\n\r",buf);
            printf("written to memory\n\r");
            myled = 1;
            t4.signal_set(SETT_OFF);
            }
            //Thread::wait(200);
            //myled = 0;
            //Thread::wait(100);
            //wait(1);
            }
            }
}
void function4()
{
        while (true){
    Thread::signal_wait(SETT_OFF);    
    char buffer [128];
    scanf("%127s", buffer);
    string buffer_str(buffer);
    char date [32];
    strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
        if(buffer_str=="READ") {
            printf("%s\n\r", buf);
            myled = 1;
            t5.signal_set(READ_OFF);
            }
            //Thread::wait(200);
            //myled = 0;
            //Thread::wait (100);
        }
    }

int main()
{
    pc.baud(9600); //sets baud rate to 9600
    idMain = osThreadGetId();
    t1.start(function1);
    t2.start(function2);
    t3.start(function3);
    t4.start(function4);
    id1 = t1.gettid();
    id2 = t2.gettid();
    id3 = t3.gettid();
    id4 = t4.gettid();
    time_t seconds = time(NULL);
    char time [32];
    strftime(time, 32, "%H:%M:%S %p", localtime(&seconds));
    humidity.init();
    humidity.calib();
    printf("Type SETTIME to set time and date [enter] \n\r");
    printf("Type SETT to start sampling [ENTER]\n\r");
    printf("Type DELETEALL to delete sensor data [enter]\n\r");
    printf("Type READALL [enter]\n\r");
    printf("Type READ to read sensor data in memory [ENTER]\n\r");





    while(1) {
        char buffer [128];
        scanf("%127s", buffer);
        string buffer_str(buffer);
        osSignalWait(ALL_OFF,osWaitForever);


        if(buffer_str=="?") {
            printf("SOFT253 simple Temperature Humidity and Pressure Sensor Monitor\n\r");
            printf("Using the X-NUCLEO-IKS01A1 shield and MBED Libraries\n\r");
        }
        

    }


}
