#include "mbed.h"
#include "Keypad.h"
 
 // Define your own keypad values
 char Keytable[] = { '1', '2', '3', 'A',   // r0
                     '4', '5', '6', 'B',   // r1
                     '7', '8', '9', 'C',   // r2
                     '*', '0', '#', 'D',   // r3
                   };
                  // c0   c1   c2   c3
 
 uint32_t Index;
 uint32_t pass = 1234,check=1,modc=1000; //password is 1234, modc is current val of mod. the value will be 10^(n-1). n is no of digits of pass
 DigitalOut led1(LED_BLUE);
 DigitalOut led2(LED_GREEN);
 DigitalOut led3(LED_RED);
   
 uint32_t cbAfterInput(uint32_t index) {
     Index = index;
     led1=!led1;
     if(check == 1)
      if(pass/modc == Index)
       { check = 1;
         modc=modc/10;
       } 
      else check =0;
     else check =0; 
     
     if(modc==0)
      if(check == 1) led2=!led2;  
      else led3=!led3;
     else;  
     pass=pass%10;
      return 0;
 }
 
 int main() {
                 // r0    r1    r2    r3    c0     c1     c2   c3
     Keypad keypad(PTE5, PTE4, PTE3, PTE2, PTB11, PTB10, PTB9, NC);
     keypad.attach(&cbAfterInput);
     keypad.start();  // energize the keypad via c0-c3
     //PwmOut r(LED_RED); //for checking

     while (1) {
         __wfi();
         printf("Interrupted\r\n");
         printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);
     }
 }