#include "mbed.h"
#include "USBMIDI.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

#define FastSpeedInterface 0
#define HighSpeedInterface 1 
#define MAXRead 10

void PL1(void);

Serial pc(USBTX, USBRX);
Timeout TU1;

TS_DISCO_F746NG ts;
LCD_DISCO_F746NG lcd;

USBMIDI midi(HighSpeedInterface);

DigitalIn I0(D0);
DigitalIn I1(D1);
DigitalIn I2(D2);
DigitalIn I3(D3);
DigitalIn I4(D4);
DigitalIn I5(D5);
DigitalIn I6(D6);
DigitalIn I7(D7);

DigitalOut L8(D8);
DigitalOut L9(D9);
DigitalOut L10(D10);
DigitalOut L11(D11);
DigitalOut L12(D12);
DigitalOut L13(D13);
DigitalOut L14(D14);
DigitalOut L15(D15);

AnalogIn Ain(A0);

int XA[8]; 
int XB[8]; 
int XC[8]; 
int XD[8]; 
int XE[8]; 
int XF[8]; 
int XG[8];
int XH[8]; 

float tempo=120;
int Xtap=0;
float Af;

int main()
{
    pc.baud(9600);
    pc.format(8, SerialBase::None, 1);
    
    TS_StateTypeDef TS_State;

    char str[50];
    
    TU1.attach(&PL1, 0.5);
    TU1.detach();
    
    lcd.Clear(LCD_COLOR_GRAY);
    lcd.SetBackColor (LCD_COLOR_GRAY);
    lcd.SetTextColor (LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Sequencer", CENTER_MODE);
    
    lcd.SetTextColor (LCD_COLOR_DARKGRAY);
    lcd.DrawRect( 30, 80, 50, 120);
    lcd.FillRect( 30, 80, 50, 120);
    lcd.DrawRect( 90, 80, 50, 120);
    lcd.FillRect( 90, 80, 50, 120);
    lcd.DrawRect( 150, 80, 50, 120);
    lcd.FillRect( 150, 80, 50, 120);
    lcd.DrawRect( 210, 80, 50, 120);
    lcd.FillRect( 210, 80, 50, 120);
    lcd.DrawRect( 270, 80, 50, 120);
    lcd.FillRect( 270, 80, 50, 120);
    lcd.DrawRect( 330, 80, 50, 120);
    lcd.FillRect( 330, 80, 50, 120);
    lcd.DrawRect( 390, 80, 50, 120);
    lcd.FillRect( 390, 80, 50, 120);
    
    LOOP:while(1){
        Af = Ain.read();
        for(int i=0; i<MAXRead-1; i++){
            Af += Ain.read();
        }
        Af /= MAXRead;
        
        ts.GetState(&TS_State);

        sprintf(str, "Up %.f Down",tempo);
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)str, LEFT_MODE);
        
        lcd.SetTextColor (LCD_COLOR_DARKGREEN);
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)" PAUSE    PLAY ", RIGHT_MODE);
    
        if (Xtap == 0){
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 1){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 2){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 3){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 4){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 5){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
        }
        if (Xtap == 6){
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
            lcd.DrawRect( 30, 80, 50, 120);
            lcd.FillRect( 30, 80, 50, 120);
            lcd.DrawRect( 90, 80, 50, 120);
            lcd.FillRect( 90, 80, 50, 120);
            lcd.DrawRect( 150, 80, 50, 120);
            lcd.FillRect( 150, 80, 50, 120);
            lcd.DrawRect( 210, 80, 50, 120);
            lcd.FillRect( 210, 80, 50, 120);
            lcd.DrawRect( 270, 80, 50, 120);
            lcd.FillRect( 270, 80, 50, 120);
            lcd.DrawRect( 330, 80, 50, 120);
            lcd.FillRect( 330, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_BLUE);
            lcd.DrawRect( 390, 80, 50, 120);
            lcd.FillRect( 390, 80, 50, 120);
            lcd.SetTextColor (LCD_COLOR_DARKGRAY);
        }
        
        if (I0 == 1) {
        }
        if (I0 == 0) {
            if (XA[Xtap] == 0){
                    XA[Xtap] = 1;
            }
            else {
                    XA[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I1 == 1) {
        }
        if (I1 == 0) {
            if (XB[Xtap] == 0){
                    XB[Xtap] = 1;
            }
            else {
                    XB[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I2 == 1) {
        }
        if (I2 == 0) {
            if (XC[Xtap] == 0){
                    XC[Xtap] = 1;
            }
            else {
                    XC[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I3 == 1) {
        }
        if (I3 == 0) {
            if (XD[Xtap] == 0){
                    XD[Xtap] = 1;
            }
            else {
                    XD[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I4 == 1) {
        }
        if (I4 == 0) {
            if (XE[Xtap] == 0){
                    XE[Xtap] = 1;
            }
            else {
                    XE[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I5 == 1) {
        }
        if (I5 == 0) {
            if (XF[Xtap] == 0){
                    XF[Xtap] = 1;
            }
            else {
                    XF[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I6 == 1) {
        }
        if (I6 == 0) {
            if (XG[Xtap] == 0){
                    XG[Xtap] = 1;
            }
            else {
                    XG[Xtap] = 0;
            }
            wait_ms(300);
        }
        if (I7 == 1) {
        }
        if (I7 == 0) {
            if (XH[Xtap] == 0){
                    XH[Xtap] = 1;
            }
            else {
                    XH[Xtap] = 0;
            }
            wait_ms(300);
        }
        
        if (XA[Xtap]==0){
            L8 = 0;
        }
        if (XA[Xtap]==1){
            L8 = 1;
        }
        if (XB[Xtap]==0){
            L9 = 0;
        }
        if (XB[Xtap]==1){
            L9 = 1;
        }
        if (XC[Xtap]==0){
            L10 = 0;
        }
        if (XC[Xtap]==1){
            L10 = 1;
        }
        if (XD[Xtap]==0){
            L11 = 0;
        }
        if (XD[Xtap]==1){
            L11 = 1;
        }
        if (XE[Xtap]==0){
            L12 = 0;
        }
        if (XE[Xtap]==1){
            L12 = 1;
        }
        if (XF[Xtap]==0){
            L13 = 0;
        }
        if (XF[Xtap]==1){
            L13 = 1;
        }
        if (XG[Xtap]==0){
            L14 = 0;
        }
        if (XG[Xtap]==1){
            L14 = 1;
        }
        if (XH[Xtap]==0){
            L15 = 0;
        }
        if (XH[Xtap]==1){
            L15 = 1;
        }
        
        if((TS_State.touchDetected))
        {
           if(TS_State.touchX[0]>=30&&TS_State.touchX[0]<=80&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 0;
            }
            else if(TS_State.touchX[0]>=90&&TS_State.touchX[0]<=140&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 1;
            }
            else if(TS_State.touchX[0]>=150&&TS_State.touchX[0]<=200&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 2;
            }
            else if(TS_State.touchX[0]>=210&&TS_State.touchX[0]<=260&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 3;
            }
            else if(TS_State.touchX[0]>=270&&TS_State.touchX[0]<=320&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 4;
            }else if(TS_State.touchX[0]>=330&&TS_State.touchX[0]<=380&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 5;
            }else if(TS_State.touchX[0]>=390&&TS_State.touchX[0]<=440&&TS_State.touchY[0]>=80&&TS_State.touchY[0]<=200)
            {
                Xtap = 6;
            }
            else if(TS_State.touchX[0]>=1&&TS_State.touchX[0]<=40&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                tempo++;
            }
            else if(TS_State.touchX[0]>=130&&TS_State.touchX[0]<=210&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                tempo--;
            }
            else if(TS_State.touchX[0]>=340&&TS_State.touchX[0]<=440&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP2;
            }
            wait_ms(400);
        }
    }
    LOOP2:while (1){
        Af = Ain.read();
        for(int i=0; i<MAXRead-1; i++){
            Af += Ain.read();
        }
        Af /= MAXRead;
        
        ts.GetState(&TS_State);
        
        lcd.SetTextColor (LCD_COLOR_DARKRED);
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)" PAUSE    PLAY ", RIGHT_MODE);
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        midi.write(MIDIMessage::AllNotesOff(0));
        if (XA[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XA[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XA[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XA[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        
        else{}
        if (XA[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XA[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XA[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XB[0] == 1){
            midi.write(MIDIMessage::NoteOn(36));
        }
        else{}
        
        if (XB[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XB[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XB[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XB[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XB[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XB[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XC[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XC[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XC[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XC[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XC[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XC[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XC[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XD[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XD[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XD[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XD[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XD[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XD[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XD[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XE[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XE[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XE[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XE[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XE[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XE[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XE[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XF[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XF[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XF[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XF[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XF[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XF[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XF[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XG[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XG[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XG[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XG[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XG[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XG[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XG[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
        
        if (XH[0] == 1){
            midi.write(MIDIMessage::NoteOn(36,127*Af));
        }
        else{}
        
        if (XH[1] == 1){
            midi.write(MIDIMessage::NoteOn(38,127*Af));
        }
        else{}
        
        if (XH[2] == 1){
            midi.write(MIDIMessage::NoteOn(39,127*Af));
        }
        else{}
        
        if (XH[3] == 1){
            midi.write(MIDIMessage::NoteOn(44,127*Af));
        }
        else{}
        
        if (XH[4] == 1){
            midi.write(MIDIMessage::NoteOn(46,127*Af));
        }
        else{}
        
        if (XH[5] == 1){
            midi.write(MIDIMessage::NoteOn(50,127*Af));
        }
        else{}
        
        if (XH[6] == 1){
            midi.write(MIDIMessage::NoteOn(52,127*Af));
        }
        else{}
        
        wait(30/tempo);
        midi.write(MIDIMessage::AllNotesOff(0));
        
        if((TS_State.touchDetected))
        {
            if(TS_State.touchX[0]>=260&&TS_State.touchX[0]<=330&&TS_State.touchY[0]>=230&&TS_State.touchY[0]<=270)
            {
                goto LOOP;
            }
        }
        else{}
    }
}

void PL1(){
    for (int i=0; i<8; i++){
        XA[i] = 0;
        XB[i] = 0;
        XC[i] = 0;
        XD[i] = 0;
        XE[i] = 0;
        XF[i] = 0;
        XG[i] = 0;
    }
}