#include "mbed.h"
#include "Motor.h"
#include <ctime>
#include <string>
#include <cstdio>
#include "SongPlayer.h"

using namespace std;

DigitalOut led(LED4);
DigitalOut softReset(p12);
Serial blue(p28,p27);
Motor motorA(p21, p19, p17); //pwm, fwd, rev
Motor motorB(p22,p23, p24); //pwm, fwd, rev
Ticker IRflip;
AnalogIn IR(p16);
void motorStop();

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

////////////////GLOBALS
clock_t startTime;
clock_t endTime;
string time_str;
int movingMotors = 0;

///////////////Function init
void writeSD(double seconds);
double readSD();
void reset();
void playSound(char*);
void motorStop();


///////////////////Functions
void reset()
{
       softReset = 1;
       wait(.5);
       softReset = 0;
}
void motorStop()
{
    
    string str;
    if(IR <= .2f) 
        {
            led2 = 1;
            endTime = clock();
            double seconds = endTime-startTime; 
            writeSD(seconds);
            led3 =1;
            wait(0.5);
            led = 0;
            motorB.speed(0);
            motorA.speed(0);
            reset();
        }
}
double readSD()
{
    double seconds= LPC_RTC->GPREG0;
    LPC_RTC->GPREG0 = 0;
    return seconds;
}

void writeSD(double seconds)
{
    LPC_RTC->GPREG0 = seconds;
}
int main()
{
    int counter = 1;
    char bnum=0;
    while(1) 
    {
        if (blue.getc()=='!' && counter == 1) 
        {
            counter--;
            if (blue.getc()=='B') //button data
            { 
                
                bnum = blue.getc(); //button number
                if(bnum=='1') //press number 1
                {
                    led1 = 1;
                    startTime = clock();
                    IRflip.attach(&motorStop, 0.05);  
                    
                    motorA.speed(1);
                    motorB.speed(1);
                } 
                else if(bnum == '2') //press number 2
                {
                    motorA.speed(0);
                    motorB.speed(0);
                }
                else if(bnum == '3') //rev
                {
                    double sdTime = readSD();
                    clock_t temp = clock(); 
                    double unwind =  (sdTime + temp) + (sdTime + temp)* .065;
                    while((double)clock() <= unwind)
                    {
                        motorA.speed(-1);
                        motorB.speed(-1);
                    }
                    
                    motorA.speed(0);
                    motorB.speed(0);
                    reset();
                }
                else if(bnum == '4') //press number 4
                {
                    motorA.speed(0);
                    motorB.speed(0);
                }
            }// if 'B'
        }//if '!'
    }//while
}//main