#define FRAME_SIZE      127
#define STARTBYTE       0x7E
#define MAX_DATA_LEN    70

#define TX_STATUS       0x89
#define TX_REQUEST_64   0x00
#define RX_PACKET_64    0x80

class xbeeFrame : public xbee
{
private:
    PinName _tx;
    PinName _rx;
    PinName _reset;

    char _apiFrame[FRAME_SIZE];   //fully assembled frame
    unsigned char _length[2];               //length bytes
    unsigned char _frameType;              //frame type
    unsigned char _frameID;                //frame id
    unsigned char _destAddr[8];            //destination address
    unsigned char _sourceAddr[8];          //source address
    unsigned char _options;                 //other options
    char* _payload;                         //actual data to be sent/received
    unsigned char _checksum;                //checksum byte
    unsigned char _rssi;                    // RSSI
    char* _rfData;                          //pointer to an array to store incoming data
    unsigned char _status;                  //status of transmitted frame
    
public:
    /** Configure serial data pin.
      * @param tx The serial tx pin the xbee is conected to.
      * @param rx The serial rx pin the xbee is conected to.
      * @param reset The pin connected to the Xbee reset pin.
      */
    xbeeFrame(PinName tx, PinName rx, PinName reset);
    ~xbeeFrame();
    /** Initializes the frame
      */
    void InitFrame(void);
    /** Assembles the frame to be sent
      */  
    void AssembleFrame(void);
    /** Calculates the checksum of the frame
      * @return Returns the checksum of the frame
      */
    char CalculateChecksum(void);
    /** Calculates the length of the frame
      * @return Returns the length of the frame
      */
    int CalculateLength(void);
    /** Get the length of the frame
      * @return Returns the length of the packet
      */
    int GetLength(void);
    /** Get the type of the frame
      * @return Returns the type of the packet
      */
    int GetType(void);
    /** Get the status of the sent frame
      * @return Returns the status of sent packet
      */    
    int GetStatus(void);
    /** Set the packet destination address 
      * @param dest_address Pointer to a array storing destination address
      */
    void SetDestination(unsigned char* dest);
    /** Set the packet payload 
      * @param payload Pointer to a array storing payload (must be '\0' ended)
      */
    void SetPayload(char* payload);    
    /** Parses the received frame into proper data fields
      */
    void ParseFrame(void);
    /** Prints the received frame information
      */
    void PrintData(void);    
    /** Sends the frame
      */
    void SendFrame(void);    
    /** Receives the frame
      */
    void ReceiveFrame(char* buf, int timeout);
    /** Returns pointer to api frame
      */
    char* GetFramePointer(void);
    /** Indicates if the frame has been received
      */
    unsigned char frameReceived;
    
    void PrintPayload();
};