/*
    Sample program to use a rocker IS switch from NKK.
    Part of this program is derived from a sample program for PIC
    micro cotnroller written by NKK.
*/

#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd");
SPI spi(p11, p12, p13); // mosi(SDO), miso(SDI), sclk(SCLK)
DigitalOut is_cs(p21);
DigitalOut is_reset(p22);
DigitalOut is_dc(p23);
DigitalOut is_vcc(p24);
DigitalOut led1(LED1);
DigitalIn  sw1(p18);
DigitalIn  sw2(p19);
DigitalIn  sw3(p20);

void    OledSendCommand( const unsigned char *com );
void    OledInit( void );
void    OledSendData( const unsigned char *dat, int len );

const int DAT = 1;
const int CMD = 0;

unsigned char dat[96*64/8];
const unsigned char cls[96*64/8] = {0};

int main() {
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 4MHz clock rate
    spi.format(8, 3);
    spi.frequency(4000000);
 
    is_reset = 0;
    is_vcc = 0;

    OledInit();

    for (;;) {
        DIR *d;
        struct dirent *p;
        d = opendir("/sd/bw");
        if (d != NULL) {
            while ((p = readdir(d)) != NULL) {
                char fname[20];
                sprintf(fname, "/sd/bw/%s", p->d_name);
                FILE *fp = fopen(fname, "rb");
                if (fp == NULL) {
                    // error("Could not open file for read\n");
                } else {
                    fread(dat, 1, 8, fp); // skip header
                    fread(dat, 1, sizeof(dat), fp);
                    fclose(fp);
                    OledSendData(dat, 96*64/8);
                    wait_ms(100);
                    while (sw1 && sw2 && sw3)
                        ;
                }
            }
            closedir(d);
        }
    }
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//    OLED controll commands (Initial settings commands)
const    unsigned char    SoftwareReset[]                =    {    0x01,    0x01    };
const    unsigned char    DotMatrixDisplay[]            =    {    0x02,    0x02,    0x00    };
const    unsigned char    SetRWOperation[]            =    {    0x02,    0x07,    0x00    };
const    unsigned char    SetDisplayDirection[]        =    {    0x02,    0x09,    0x00    };
const    unsigned char    DotMatrixStandby[]            =    {    0x02,    0x14,    0x00    };
const    unsigned char    GraphicMemoryWrite[]        =    {    0x02,    0x1d,    0x00    };
const    unsigned char    SetupColumnAddress[]        =    {    0x03,    0x30,    0x00,    0x5f    };
const    unsigned char    SetupRowAddress[]            =    {    0x03,    0x32,    0x00,    0x3f    };
const    unsigned char    XaxisRWStartPoint[]             =    {    0x02,    0x34,    0x00    };
const    unsigned char    XaxisRWEndPoint[]             =    {    0x02,    0x35,    0x0b    };
const    unsigned char    YaxisRWStartPoint[]             =    {    0x02,    0x36,    0x00    };
const    unsigned char    YaxisRWEndPoint[]             =    {    0x02,    0x37,    0x3f    };
const    unsigned char    XaxisRStartAddress[]         =    {    0x02,    0x38,    0x00    };
const    unsigned char    YaxisRStartAddress[]         =    {    0x02,    0x39,    0x00    };
const    unsigned char    SetScreenSaverTimer1[]         =    {    0x02,    0xc3,    0x00    };
const    unsigned char    SetScreenSaverTimer2[]         =    {    0x02,    0xc4,    0x00    };
const    unsigned char    RepeatScreenSaver[]         =    {    0x02,    0xcc,    0x00    };
const    unsigned char    StartStopScreenSaver[]         =    {    0x02,    0xcd,    0x00    };
const    unsigned char    SetSystemClock[]             =    {    0x02,    0xd0,    0x80    };
const    unsigned char    SetSTBYPin[]                 =    {    0x02,    0xd2,    0x00    };
const    unsigned char    DACASetting[]                 =    {    0x02,    0xd4,    0x00    };
const    unsigned char    DACBSetting[]                 =    {    0x02,    0xd5,    0x00    };
const    unsigned char    DACCSetting[]                 =    {    0x02,    0xd6,    0x00    };
const    unsigned char    DACDSetting[]                 =    {    0x02,    0xd7,    0x00    };
const    unsigned char    DimmerSetting[]                =    {    0x02,    0xdb,    0x0f    };

const    unsigned char    Reserved1[]                    =    {    0x02,    0x10,    0x03    };
const    unsigned char    Reserved2[]                    =    {    0x02,    0x12,    0x63    };
const    unsigned char    Reserved3[]                    =    {    0x02,    0x13,    0x00    };
const    unsigned char    Reserved4[]                    =    {    0x02,    0x16,    0x00    };
const    unsigned char    Reserved5[]                    =    {    0x02,    0x17,    0x00    };
const    unsigned char    Reserved6[]                    =    {    0x02,    0x18,    0x09    };
const    unsigned char    Reserved7[]                    =    {    0x02,    0x1a,    0x04    };
const    unsigned char    Reserved8[]                    =    {    0x02,    0x1c,    0x00    };
const    unsigned char    Reserved9[]                    =    {    0x02,    0x48,    0x03    };
const    unsigned char    Reserved10[]                =    {    0x02,    0xd9,    0x00    };
const    unsigned char    Reserved11[]                =    {    0x02,    0xdd,    0x88    };

const    unsigned char    SendImage[]                    =    {    0x01,    0x08    };
const    unsigned char    DotMatrixDisplayON[]            =    {    0x02,    0x02,    0x01    };

//
//        initializing OLED
//
void    OledInit( void )    {
    //    reset OLED
    is_vcc = 0;
    is_reset = 0;
    wait_us(3);
    is_vcc = 1;
    wait_ms(1);
    is_reset = 1;

    // initial settings
    OledSendCommand( SoftwareReset );
    wait_us(3);
    OledSendCommand( DotMatrixDisplayON );
//    OledSendCommand( DotMatrixDisplay );
    OledSendCommand( SetRWOperation );
    OledSendCommand( SetDisplayDirection );
    OledSendCommand( Reserved1 );
    OledSendCommand( Reserved2 );
    OledSendCommand( Reserved3 );
    OledSendCommand( DotMatrixStandby );
    OledSendCommand( Reserved4 );
    OledSendCommand( Reserved5 );
    OledSendCommand( Reserved6 );
    OledSendCommand( Reserved7 );
    OledSendCommand( Reserved8 );
    OledSendCommand( GraphicMemoryWrite );
    OledSendCommand( SetupColumnAddress );
    OledSendCommand( SetupRowAddress );
    OledSendCommand( XaxisRWStartPoint );
    OledSendCommand( XaxisRWEndPoint );
    OledSendCommand( YaxisRWStartPoint );
    OledSendCommand( YaxisRWEndPoint );
    OledSendCommand( XaxisRStartAddress );
    OledSendCommand( YaxisRStartAddress );
    OledSendCommand( Reserved9 );
    OledSendCommand( SetScreenSaverTimer1 );
    OledSendCommand( SetScreenSaverTimer2 );
    OledSendCommand( RepeatScreenSaver );
    OledSendCommand( StartStopScreenSaver );
    OledSendCommand( SetSystemClock );
    OledSendCommand( SetSTBYPin );
    OledSendCommand( DACASetting );
    OledSendCommand( DACBSetting );
    OledSendCommand( DACCSetting );
    OledSendCommand( DACDSetting );
    OledSendCommand( Reserved10 );
    OledSendCommand( DimmerSetting );
    OledSendCommand( Reserved11 );
}

//
//      Send a command / data to OLED via SPI
//
void    OledSend( const unsigned char *p, int len )    {
    for (; len>0; len --, p ++) {
        is_cs = 0;
        spi.write(*p);
        is_cs = 1;
    }
}

//
//        Send a command to OLED
//
void    OledSendCommand( const unsigned char *com )    {
    is_dc = CMD;
    OledSend(com+1, 1);
    is_dc = DAT;
    OledSend(com+2, *com-1);
}

//
//        Send data to OLED
//
void    OledSendData( const unsigned char *dat, int len )    {
    OledSendCommand( SendImage );
    is_dc = DAT;
    OledSend(dat, len);
    OledSendCommand( DotMatrixDisplayON );
}
