/* 4D Systems uCam serial RAW/JPEG camera library
 * Copyright (c) 2011, Noriaki Mitsunaga
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef __UCAM_H__
#define __UCAM_H__

#include "mbed.h"

#define UCAM_COLOR_TYPE_2BITG  0x1
#define UCAM_COLOR_TYPE_4BITG  0x2
#define UCAM_COLOR_TYPE_8BITG  0x3
#define UCAM_COLOR_TYPE_RGB332 0x4
#define UCAM_COLOR_TYPE_RGB444 0x5
#define UCAM_COLOR_TYPE_RGB565 0x6
#define UCAM_COLOR_TYPE_JPEG   0x7

#define UCAM_RAW_RESOLUTION_80X60   0x1
#define UCAM_RAW_RESOLUTION_160X120 0x3
#define UCAM_RAW_RESOLUTION_320X240 0x5
#define UCAM_RAW_RESOLUTION_640X480 0x7
#define UCAM_RAW_RESOLUTION_128x128 0x9
#define UCAM_RAW_RESOLUTION_128x96  0xB

const int ucam_raw_resolution_w[] = {80, 160, 320, 640, 128, 128};
const int ucam_raw_resolution_h[] = {60, 120, 240, 480, 128, 96};

#define UCAM_JPEG_RESOLUTION_80X64   0x1
#define UCAM_JPEG_RESOLUTION_160X128 0x3
#define UCAM_JPEG_RESOLUTION_320X240 0x5
#define UCAM_JPEG_RESOLUTION_640X480 0x7

class uCam {
public:
    uCam(PinName tx, PinName rx) {
        s = new Serial(tx, rx);
        s->baud(57600);
    }
    ~uCam() {
        delete s;
    }

    int Command(const unsigned char *cmd);
    void ACK_F0F0();
    int Init();
    int LightFreq(int f);
    void Reset();
    int SnapshotRaw(int Color, int Res, unsigned char *buf);
    int SnapshotRawCrop(int Color, int Res,
                        int x0, int y0, int w, int h,
                        unsigned char *buf);
    int SnapshotJPEGi(int Res, int pksz);
    int SnapshotJPEGd(int no, unsigned char *buf, int pksz);

private:
    Serial *s;

    int  checkACK(const unsigned char *buf);
    int  checkSYNC(const unsigned char *buf);
    void read(unsigned char *p, int len);
    int  readT(unsigned char *buf, int len);
    void write(const unsigned char *p, int len);
};

#endif
