/* mbed NKK IS-C15/C01 oLED switch library
 * Copyright (c) 2011, Noriaki Mitsunaga
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef __ISC15_H__
#define __ISC15_H__

#include "mbed.h"

#define ISC15_DEVICE_ISC01 0
#define ISC15_DEVICE_ISC15 1

#define ISC15_DSPMODE_256 0
#define ISC15_DSPMODE_64K 1

#define ISC15_WIDTH 64
#define ISC15_HEIGHT 48

class ISC15 {
public:
    ISC15( PinName cs, PinName reset, PinName dc, PinName vcc )
            : is_cs(cs), is_reset(reset), is_dc(dc), is_vcc(vcc) {
        DevType = 1;
        spi = NULL;
    }
    void    Cls() {
        Fill(0);
    };
    void    Disp( int Mode, const unsigned char *dat );
    void    Fill( unsigned char c );
    void    Init( int DeviceType, SPI *s );

private:
    DigitalOut is_cs, is_reset, is_dc, is_vcc;
    int DevType; // 0:ISC01, 1:ISC15
    SPI *spi;

    void    AdrInit( int DevType );
    void    DspMode( int DspMode_ );
    void    Send( const unsigned char *p, int len );
    void    SendCommand( const unsigned char *com );
    void    SendData( const unsigned char *dat, int len );
};
#endif
