/**
* @section LICENSE
*Copyright (c) 2010 ARM Ltd.
*
*Permission is hereby granted, free of charge, to any person obtaining a copy
*of this software and associated documentation files (the "Software"), to deal
*in the Software without restriction, including without limitation the rights
*to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*copies of the Software, and to permit persons to whom the Software is
*furnished to do so, subject to the following conditions:
* 
*The above copyright notice and this permission notice shall be included in
*all copies or substantial portions of the Software.
* 
*THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*THE SOFTWARE.
* 
*
* @section DESCRIPTION
*
*
*/

#ifndef ADJDCOLOURSENS_H_
#define ADJDCOLOURSENS_H_

/**
*
* Includes
*
*/
#include "mbed.h"
/**
* A class to interface with an Avago ADJD-S371-QR999. 
* The class allows you to read the light levels setected by the sensor for each colour and to set the gain settings.
*/
class ADJDColourSensor{
public:
    ADJDColourSensor(PinName sda, PinName scl, PinName LED);
    
    /**
    * Read all the colors.
    */
    
    void readColors();
    
    int red();
    int green();
    int blue();
    int clear();
    int redCap();
    int greenCap();
    int blueCap();
    int clearCap();
    int redInt();
    int greenInt();
    int blueInt();
    int clearInt();
    
    int dotProduct(int* features);
    double dotProduct(double* features);

    /**
    * Read the colour sensor channels. 
    * The red, green and blue values are
    *
    * @returns The clear result, ie the overall brightness
    */
    float read();
    
    /**
    * Read the offsets from the device and into the corresponding members. 
    * 
    * @returns The value of the clear offset
    */
    int readOffset();
    
    //float red, green, blue;
    
    signed int redOffset, greenOffset, blueOffset, clearOffset;
    
    /**
    * Set the number of capacitors for each channel of the ADC.
    *
    * The values of the parameters must be between 0x00 and 0x0F
    * @param redCap The number of capacitors for the red channel
    */
    void setCapacitors(int redCap, int greenCap, int blueCap, int clearCap);
    
    /**
    * Set the integration time slot for each of the ADCs.
    * 
    * All the values are as a 12 bit number
    * @param redInt The integration time slot for the red channel
    * @param greenInt The integration time slot for the green channel
    * @param blueInt The integration time slot for the blue channel
    * @param clearInt The integration time slot for the clear channel
    */
    void setIntegrationTimeSlot(int redInt, int greenInt, int blueInt, int ClearInt);

    void optimise();
    void optimise(int optimum);
    void optimise(int redTarget, int blueTarget, int greenTarget, int clearTarget);
    
    
private:    
    I2C _sensor;
    DigitalOut _LED;
    int _red, _green, _blue, _clear;
    int _address;
    int _redCap, _greenCap, _blueCap, _clearCap;
    int _redInt, _greenInt, _blueInt, _clearInt;
};
#endif